/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class JMSAppender
extends AppenderSkeleton {
    static int SUCCESSIVE_FAILURE_LIMIT = 3;
    String securityPrincipalName;
    String securityCredentials;
    String initialContextFactoryName;
    String urlPkgPrefixes;
    String providerURL;
    String topicBindingName;
    String tcfBindingName;
    String userName;
    String password;
    boolean locationInfo;
    TopicConnection topicConnection;
    TopicSession topicSession;
    TopicPublisher topicPublisher;
    boolean inOrder = false;
    int successiveFailureCount = 0;

    public JMSAppender() {
        super(false);
    }

    public void setTopicConnectionFactoryBindingName(String tcfBindingName) {
        this.tcfBindingName = tcfBindingName;
    }

    public String getTopicConnectionFactoryBindingName() {
        return this.tcfBindingName;
    }

    public void setTopicBindingName(String topicBindingName) {
        this.topicBindingName = topicBindingName;
    }

    public String getTopicBindingName() {
        return this.topicBindingName;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
        try {
            InitialContext jndi;
            this.getLogger().debug("Getting initial context.");
            if (this.initialContextFactoryName != null) {
                Properties env = new Properties();
                env.put("java.naming.factory.initial", this.initialContextFactoryName);
                if (this.providerURL != null) {
                    env.put("java.naming.provider.url", this.providerURL);
                } else {
                    this.getLogger().warn("You have set InitialContextFactoryName option but not the ProviderURL. This is likely to cause problems.");
                }
                if (this.urlPkgPrefixes != null) {
                    env.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
                }
                if (this.securityPrincipalName != null) {
                    env.put("java.naming.security.principal", this.securityPrincipalName);
                    if (this.securityCredentials != null) {
                        env.put("java.naming.security.credentials", this.securityCredentials);
                    } else {
                        this.getLogger().warn("You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
                    }
                }
                jndi = new InitialContext(env);
            } else {
                jndi = new InitialContext();
            }
            this.getLogger().debug((Object)"Looking up [{}]", this.tcfBindingName);
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(jndi, this.tcfBindingName);
            this.getLogger().debug("About to create TopicConnection.");
            this.topicConnection = this.userName != null ? topicConnectionFactory.createTopicConnection(this.userName, this.password) : topicConnectionFactory.createTopicConnection();
            this.getLogger().debug("Creating TopicSession, non-transactional, in AUTO_ACKNOWLEDGE mode.");
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.getLogger().debug("Looking up topic name [" + this.topicBindingName + "].");
            Topic topic = (Topic)this.lookup(jndi, this.topicBindingName);
            this.getLogger().debug("Creating TopicPublisher.");
            this.topicPublisher = this.topicSession.createPublisher(topic);
            this.getLogger().debug("Starting TopicConnection.");
            this.topicConnection.start();
            jndi.close();
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Error while activating options for appender named [" + this.name + "]."), e);
        }
        this.inOrder = this.topicConnection != null && this.topicSession != null && this.topicPublisher == null;
    }

    protected Object lookup(Context ctx, String name) throws NamingException {
        try {
            return ctx.lookup(name);
        }
        catch (NameNotFoundException e) {
            this.getLogger().error("Could not find name [" + name + "].");
            throw e;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.getLogger().debug("Closing appender [" + this.name + "].");
        this.closed = true;
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)("Error while closing JMSAppender [" + this.name + "]."), e);
        }
        this.topicPublisher = null;
        this.topicSession = null;
        this.topicConnection = null;
    }

    protected boolean checkEntryConditions() {
        return this.inOrder;
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        try {
            ObjectMessage msg = this.topicSession.createObjectMessage();
            if (this.locationInfo) {
                event.getLocationInformation();
            }
            msg.setObject((Serializable)event);
            this.topicPublisher.publish((Message)msg);
            this.successiveFailureCount = 0;
        }
        catch (Exception e) {
            ++this.successiveFailureCount;
            if (this.successiveFailureCount > SUCCESSIVE_FAILURE_LIMIT) {
                this.inOrder = false;
            }
            this.getLogger().error((Object)("Could not publish message in JMSAppender [" + this.name + "]."), e);
        }
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    public void setInitialContextFactoryName(String initialContextFactoryName) {
        this.initialContextFactoryName = initialContextFactoryName;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    String getURLPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void setURLPkgPrefixes(String urlPkgPrefixes) {
        this.urlPkgPrefixes = urlPkgPrefixes;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public String getSecurityPrincipalName() {
        return this.securityPrincipalName;
    }

    public void setSecurityPrincipalName(String securityPrincipalName) {
        this.securityPrincipalName = securityPrincipalName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    protected TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    protected TopicSession getTopicSession() {
        return this.topicSession;
    }

    protected TopicPublisher getTopicPublisher() {
        return this.topicPublisher;
    }

    public boolean requiresLayout() {
        return false;
    }
}

