/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero;

import com.tmax.tibero.DBConst;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Debug {
    public static final boolean DEBUG = false;
    public static final boolean TRACE = false;
    public static final boolean NETWORK = false;
    public static final boolean MSG = false;
    public static boolean ORA_COMPATABLE = false;
    private static final int CAT_METHOD = 0;
    private static final int CAT_RETURN = 1;
    private static final int CAT_DEBUG = 2;
    private static final int CAT_MSG = 3;
    private static final int CAT_ERROR = 4;
    private static final int CAT_WARN = 5;
    private static SimpleDateFormat dateFormat = null;
    private static SimpleDateFormat logFileDateFormat = null;
    private static PrintWriter logWriter = null;
    private static String logFileExt = "log";
    private static String logFileName = null;
    private static final long MAX_LOG_FILE_LENGTH = DBConst.GIGA * 5;

    public static void logMethod(String methodName, String[] names, Object[] args) {
        Debug._print(0, Debug.getMethodString(methodName, names, args));
    }

    public static void logReturn(String methodName, Object returnValue) {
        Debug._print(1, Debug.getMethodReturnString(methodName, returnValue));
    }

    public static void debug(String msg) {
        Debug._print(2, msg);
    }

    public static void debug(String methodName, String msg) {
        Debug._print(2, methodName + ":" + msg);
    }

    public static void log(String msg) {
        Debug._print(3, msg + "\n");
    }

    public static void log(String methodName, String msg) {
        Debug._print(2, methodName + ":" + msg);
    }

    public static void error(String msg) {
        Debug._print(4, msg);
    }

    public static void warn(String msg) {
        Debug._print(5, msg);
    }

    public static void setLogWriter(PrintWriter writer) {
        logWriter = writer;
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void logHexa(String msg, byte[] b) {
        Debug._print(2, msg + "\n" + Debug.getHexFromBytes(b));
    }

    public static void logHexa(String msg, byte[] b, int length) {
        Debug._print(2, msg + "\n" + Debug.getHexFromBytes(b, length));
    }

    public static void logHexa(String msg, char[] c) {
        Debug._print(2, msg + "\n" + Debug.getHexFromChar(c));
    }

    public static void logHexa(String msg, char[] c, int length) {
        Debug._print(2, msg + "\n" + Debug.getHexFromChar(c, length));
    }

    public static void logHexa(String msg, String s) {
        Debug._print(2, msg + "\n" + Debug.getHexFromChar(s.toCharArray()));
    }

    public static void logHexa(String msg, String s, int length) {
        Debug._print(2, msg + "\n" + Debug.getHexFromChar(s.toCharArray(), length));
    }

    public static void logHexa(String msg, int i) {
        Debug._print(2, msg + ":" + Debug.getHexFromInt(i));
    }

    public static void logBinary(String msg, byte b) {
        Debug._print(2, msg + ":" + Debug.getBinaryFromByte(b));
    }

    public static void logBinary(String msg, long l) {
        Debug._print(2, msg + ":" + Debug.getBinaryFromLong(l));
    }

    public static void logBinary(String msg, int i) {
        Debug._print(2, msg + ":" + Debug.getBinaryFromInt(i));
    }

    private static String getTimeString() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss.S");
        }
        return dateFormat.format(new Date());
    }

    private static String getLogFilePrefixString() {
        if (logFileDateFormat == null) {
            logFileDateFormat = new SimpleDateFormat("yy-MM-dd-HHmmss");
        }
        return "tbjdbc-" + logFileDateFormat.format(new Date());
    }

    private static String getMethodString(String methodName, String[] names, Object[] args) {
        StringBuffer msgBuf = new StringBuffer(1024);
        msgBuf.append(methodName + "()\n");
        if (names == null || args == null || names.length != args.length) {
            return msgBuf.toString();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            msgBuf.append("  * " + names[i] + " = " + args[i].toString());
            msgBuf.append("\n");
        }
        return msgBuf.toString();
    }

    private static String getMethodReturnString(String methodName, Object returnValue) {
        return methodName + "() returns " + returnValue + "\n";
    }

    public static String getBinaryFromInt(int i) {
        return Integer.toBinaryString(i);
    }

    public static String getBinaryFromLong(long i) {
        return Long.toBinaryString(i);
    }

    public static String getBinaryFromByte(byte b) {
        return Integer.toBinaryString(0xFF & b).substring(24);
    }

    private static String _hexFormat(int i) {
        String s = Integer.toHexString(i);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    private static String _byte2string(byte b) {
        if (b >= 32 && b <= 125) {
            return String.valueOf((char)b);
        }
        return ".";
    }

    public static String getHexFromInt(int i) {
        StringBuffer buf = new StringBuffer(32);
        buf.append(Debug._hexFormat(i >> 24 & 0xFF));
        buf.append(" ");
        buf.append(Debug._hexFormat(i >> 16 & 0xFF));
        buf.append(" ");
        buf.append(Debug._hexFormat(i >> 8 & 0xFF));
        buf.append(" ");
        buf.append(Debug._hexFormat(i >> 0 & 0xFF));
        return buf.toString();
    }

    public static String getHexFromBytes(byte[] bytes) {
        return Debug.getHexFromBytes(bytes, bytes == null ? 0 : bytes.length);
    }

    public static String getHexFromBytes(byte[] bytes, int offset, int len) {
        byte[] newbytes = new byte[len];
        System.arraycopy(bytes, offset, newbytes, 0, len);
        return Debug.getHexFromBytes(newbytes, len);
    }

    public static String getHexFromBytes(byte[] bytes, int maxLength) {
        StringBuffer buf = new StringBuffer(128);
        if (bytes == null || maxLength < 0) {
            return null;
        }
        int prtLen = Math.min(bytes.length, maxLength);
        StringBuffer byteBuf = new StringBuffer(16);
        for (int i = 0; i < prtLen; ++i) {
            buf.append(Debug._hexFormat(0xFF & bytes[i]));
            buf.append(" ");
            byteBuf.append(Debug._byte2string(bytes[i]));
            if (i % 16 != 15 && i != prtLen - 1) continue;
            buf.append("  ");
            if (i == prtLen - 1) {
                for (int k = i % 16; k < 15; ++k) {
                    buf.append("   ");
                }
            }
            buf.append("; ").append(byteBuf.toString());
            buf.append("\n");
            byteBuf.setLength(0);
        }
        return buf.toString();
    }

    public static String getHexFromChar(char[] chars) {
        if (chars == null) {
            return null;
        }
        return Debug.getHexFromChar(chars, chars.length);
    }

    public static String getHexFromChar(char[] chars, int maxLength) {
        if (chars == null || maxLength < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(128);
        int len = Math.min(chars.length, maxLength);
        buf.append("\n").append(len).append("/");
        buf.append(chars.length).append(" chars\n");
        StringBuffer charBuf = new StringBuffer(16);
        for (int i = 0; i < len; ++i) {
            buf.append(Debug._hexFormat(chars[i] >> 0 & 0xFF));
            buf.append(" ");
            buf.append(Debug._hexFormat(chars[i] >> 8 & 0xFF));
            buf.append(" ");
            charBuf.append(chars[i]);
            if (i % 8 != 7 && i != len - 1) continue;
            buf.append("  ");
            if (i == len - 1) {
                for (int k = i % 8; k < 7; ++k) {
                    buf.append("      ");
                }
            }
            buf.append("; ").append(charBuf.toString());
            buf.append("\n");
            charBuf.setLength(0);
        }
        return buf.toString();
    }

    private static void _print(int cat, String msg) {
        if (logWriter == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(msg.length() + 64);
        buf.append(Debug.getTimeString());
        Thread curThr = Thread.currentThread();
        if (curThr != null) {
            buf.append(" [");
            buf.append(curThr.getName().toUpperCase());
            buf.append("] ");
        }
        buf.append(msg);
        File logFile = new File(logFileName);
        if (logFile.length() + (long)buf.length() > MAX_LOG_FILE_LENGTH) {
            logWriter.close();
            logWriter = null;
            logFile.delete();
            try {
                logWriter = new PrintWriter(new FileWriter(logFileName));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        logWriter.write(buf.toString());
        logWriter.flush();
    }

    private static String _getLogFileName() {
        String root = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        logFileName = root == null ? Debug.getLogFilePrefixString() + "." + logFileExt : root + fileSep + Debug.getLogFilePrefixString() + "." + logFileExt;
        return logFileName;
    }

    static {
        logWriter = DriverManager.getLogWriter();
    }
}

