/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.DBConst;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbParameterMetaData;
import com.tmax.tibero.jdbc.TbRSEmpty;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.comm.TbBatchStreamDataWriter;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbSqlParser;
import com.tmax.tibero.jdbc.util.TbSqlTypeScanner;
import com.tmax.tibero.jdbc.util.TbStatementLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;

public class TbPreparedStatement
extends TbStatement
implements PreparedStatement {
    private static final int initBatchSize = DBConst.KILO * 32;
    private static final int extraBatchSize = DBConst.KILO * 64;
    public static final short FORM_CHAR = 0;
    public static final short FORM_NCHAR = 1;
    private boolean isCachedStmt = false;
    protected byte[] ppid = null;
    protected boolean preparedDDL = false;
    protected int bindParamCnt = 0;
    private int hiddenColCnt = 0;
    private int outColCnt = 0;
    private TbColumnDesc[] colMeta = null;
    protected BindData bindData = null;
    private int batchBufferSize = initBatchSize;
    private int totBatchRowCnt = 0;
    private int prevBindParamSum = 0;
    private int prevBatchRowCnt = 0;
    private int prevParamInfoSize = 0;
    private int flag = 256;
    private int[] bindParamDataType;
    private List batchInfoList = new ArrayList();
    protected TbBatchStreamDataWriter batchWriter;

    protected void reset() {
        super.reset();
        this.ppid = null;
        this.colMeta = null;
        this.bindParamDataType = null;
        this.batchInfoList.clear();
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        if (this.batchWriter != null) {
            this.batchWriter.reset();
            this.batchWriter = null;
        }
    }

    public TbPreparedStatement(TbConnection conn, String sql) throws SQLException {
        this(conn, sql, 1003, 1007, 50, false);
    }

    public TbPreparedStatement(TbConnection conn, String sql, int rsetType, int rsetConcurrency, int preFetchSize, boolean forcePrepare) throws SQLException {
        super(conn, rsetType, rsetConcurrency, preFetchSize);
        this.originalSql = this.getOriginalSql(sql);
        this.sqlTypeScanner = new TbSqlTypeScanner();
        this.sqlType = this.sqlTypeScanner.getSqlType(this.originalSql);
        if (forcePrepare) {
            this.forcePrepare();
        } else {
            this.initParameter();
        }
    }

    private void forcePrepare() throws SQLException {
        Vector paramTypes = new Vector();
        this.conn.getTbComm().prepare(this, this.originalSql, paramTypes);
        this.bindData = new BindData(this.bindParamCnt);
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem item = this.bindData.getBindItem(i);
            item.setDataType((Integer)paramTypes.get(i));
        }
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.originalSql);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.originalSql);
    }

    public boolean execute() throws SQLException {
        return this.execute(this.originalSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        this.checkConnectionOpen();
        this.initBeforeExecute();
        if (this.totBatchRowCnt == 0) {
            this.batchCounts = new int[0];
            return this.batchCounts;
        }
        try {
            int autoCommit;
            int paramInfoSize = this.batchWriter.getBufferedDataSize() - this.batchWriter.getHeaderSize();
            int bindParamSum = this.totBatchRowCnt * this.bindParamCnt;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            int n = autoCommit = this.conn.getAutoCommit() ? 1 : 0;
            if (this.batchInfoList.size() > 0) {
                if (this.totBatchRowCnt - this.prevBatchRowCnt > 0) {
                    this.batchInfoList.add(new BatchInfo(bindParamSum - this.prevBindParamSum, this.totBatchRowCnt - this.prevBatchRowCnt, paramInfoSize - this.prevParamInfoSize));
                }
                BatchInfo[] batchInfos = this.batchInfoList.toArray(new BatchInfo[0]);
                this.batchCounts = this.conn.getTbComm().batchUpdateLoop(this, this.flag, autoCommit, this.batchWriter.getHeaderSize(), batchInfos, this.totBatchRowCnt);
            } else {
                this.conn.getTbComm().batchUpdate(this, this.totBatchRowCnt, this.totBatchRowCnt, bindParamSum, this.flag, autoCommit, this.batchWriter.getHeaderSize(), paramInfoSize);
                this.batchCounts = this.conn.getTbComm().batchUpdateReply(this.totBatchRowCnt);
            }
            int[] nArray = this.batchCounts;
            return nArray;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    public synchronized void close() throws SQLException {
        if (this.conn != null && this.conn.getStmtCache() != null) {
            this.conn.getStmtCache().add(this.originalSql, this.getResultSetType(), this.getResultSetConcurrency(), this);
            return;
        }
        this.hardClose();
    }

    public synchronized void hardClose() throws SQLException {
        super.close();
    }

    public synchronized void resetCacheEntry() {
        super.resetForCache();
        this.isCachedStmt = true;
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        this.clearBatch();
    }

    public synchronized void clearBatch() {
        if (this.batchWriter != null) {
            this.batchWriter.setCurDataSize(this.batchWriter.getHeaderSize());
        }
        if (this.batchInfoList != null) {
            this.batchInfoList.clear();
        }
        this.totBatchRowCnt = 0;
        this.flag = 256;
        this.prevBindParamSum = 0;
        this.prevBatchRowCnt = 0;
        this.prevParamInfoSize = 0;
    }

    public void clearParameters() throws SQLException {
        if (this.bindData != null) {
            this.bindData.reuse();
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNullInternal(parameterIndex, DataType.getDataType(sqlType));
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(12);
        byte[] bytes = this.conn.typeConverter.booleanToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(-6);
        byte[] bytes = this.conn.typeConverter.byteToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(5);
        byte[] bytes = this.conn.typeConverter.shortToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(4);
        byte[] bytes = this.conn.typeConverter.integerToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(-5);
        byte[] bytes = this.conn.typeConverter.longToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(6);
        byte[] bytes = this.conn.typeConverter.floatToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(8);
        byte[] bytes = this.conn.typeConverter.doubleToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(parameterIndex, 1);
            return;
        }
        int execType = DataType.getDataType(3);
        byte[] bytes = this.conn.typeConverter.bigDecimalToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = this.getFormOfUse(parameterIndex) == 1 ? 19 : 3;
        if (x == null || x.equals("")) {
            this.setNullInternal(parameterIndex, execType);
            return;
        }
        if (x.length() > DBConst.MIN_DEFERRED_CHAR_CNT) {
            this.bindDeferredChars(parameterIndex, x.length(), x.toCharArray(), execType);
        } else {
            byte[] bytes = execType == 19 ? this.conn.typeConverter.fromNString(x) : this.conn.typeConverter.fromString(x);
            this.bind(parameterIndex, bytes.length, bytes, execType);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNullInternal(parameterIndex, 4);
            return;
        }
        int execType = DataType.getDataType(-2);
        if (x.length > DBConst.MIN_DEFERRED_BYTE_SIZE) {
            this.bindDeferredBytes(parameterIndex, x.length, x, execType);
        } else {
            this.bind(parameterIndex, x.length, x, execType);
        }
    }

    public void setBytes(int parameterIndex, int dataType, byte[] bytes) throws SQLException {
        if (bytes == null) {
            this.setNullInternal(parameterIndex, dataType);
            return;
        }
        this.bind(parameterIndex, bytes.length, bytes, dataType);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(parameterIndex, 5);
            return;
        }
        int execType = DataType.getDataType(91);
        byte[] bytes = this.conn.typeConverter.dateToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(parameterIndex, DataType.getDataType(92));
            return;
        }
        int execType = DataType.getDataType(92);
        byte[] bytes = this.conn.typeConverter.timeToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(parameterIndex, 7);
            return;
        }
        int execType = DataType.getDataType(93);
        byte[] bytes = this.conn.typeConverter.timestampToServerTypeCast(x, execType);
        this.bind(parameterIndex, bytes.length, bytes, execType);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null || length < 0) {
            this.setNullInternal(parameterIndex, 3);
            return;
        }
        InputStreamReader reader = new InputStreamReader(x);
        this.setCharacterStream(parameterIndex, (Reader)reader, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.conn == null) {
            return;
        }
        int execType = DataType.getDataType(-3);
        if (x == null || length < 0) {
            this.setNullInternal(parameterIndex, execType);
            return;
        }
        if (length >= DBConst.MIN_DEFERRED_BYTE_SIZE) {
            this.bind(parameterIndex, length, execType, x);
        } else {
            byte[] bytes = this.conn.typeConverter.fromBinaryStreamToBytes(x, length);
            this.bind(parameterIndex, length, bytes, execType);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        if (this.conn == null) {
            return;
        }
        try {
            int execType = this.getFormOfUse(parameterIndex) == 1 ? 19 : 3;
            if (x == null || length < 0) {
                this.setNullInternal(parameterIndex, execType);
                return;
            }
            if (length > DBConst.MIN_DEFERRED_CHAR_CNT) {
                this.bind(parameterIndex, length, execType, x);
            } else {
                char[] cbuf = new char[length];
                int charCnt = x.read(cbuf);
                if (charCnt > 0) {
                    String str = new String(cbuf, 0, charCnt);
                    byte[] bytes = execType == 19 ? this.conn.typeConverter.fromNString(str) : this.conn.typeConverter.fromString(str);
                    this.bind(parameterIndex, bytes.length, bytes, execType);
                } else {
                    this.setNullInternal(parameterIndex, execType);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(i, 12);
            return;
        }
        if (!(x instanceof TbBlob)) {
            throw new TbSQLException(-590702);
        }
        this.bind(i, ((TbLob)((Object)x)).getLocatorLength(), ((TbLob)((Object)x)).getLocator(), 12);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setClobInternal(i, 13, x);
    }

    public void setClobInternal(int i, int type, Clob x) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(i, type);
            return;
        }
        if (!(x instanceof TbClob)) {
            throw new TbSQLException(-590702);
        }
        this.bind(i, ((TbLob)((Object)x)).getLocatorLength(), ((TbLob)((Object)x)).getLocator(), type);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNullInternal(parameterIndex, 2);
            return;
        }
        switch (targetSqlType) {
            case -7: {
                this.setBoolean(parameterIndex, new Boolean(x.toString()));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (x != null) {
                    if (x instanceof Boolean) {
                        this.setString(parameterIndex, "" + ((Boolean)x != false ? 1 : 0));
                        break;
                    }
                    this.setString(parameterIndex, x.toString());
                    break;
                }
                this.setString(parameterIndex, null);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, (byte[])x);
                break;
            }
            case -6: 
            case 5: {
                if (x instanceof Number) {
                    this.setShort(parameterIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setShort(parameterIndex, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setShort(parameterIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 4: {
                if (x instanceof Number) {
                    this.setInt(parameterIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setInt(parameterIndex, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setInt(parameterIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case -5: {
                if (x instanceof Number) {
                    this.setLong(parameterIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setLong(parameterIndex, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setLong(parameterIndex, (Boolean)x != false ? 1L : 0L);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(parameterIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimal(parameterIndex, new BigDecimal(((Number)x).doubleValue()));
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimal(parameterIndex, new BigDecimal((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBigDecimal(parameterIndex, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 7: {
                if (x instanceof Number) {
                    this.setFloat(parameterIndex, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof String) {
                    this.setFloat(parameterIndex, Float.valueOf((String)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setFloat(parameterIndex, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 6: 
            case 8: {
                if (x instanceof Number) {
                    this.setDouble(parameterIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setDouble(parameterIndex, Double.valueOf((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setDouble(parameterIndex, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 2: {
                if (x instanceof Short) {
                    this.setShort(parameterIndex, (Short)x);
                    break;
                }
                if (x instanceof Integer) {
                    this.setInt(parameterIndex, (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setLong(parameterIndex, (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setFloat(parameterIndex, ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setDouble(parameterIndex, (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(parameterIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBoolean(parameterIndex, (Boolean)x);
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimal(parameterIndex, new BigDecimal((String)x));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 91: {
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof String) {
                    this.setDate(parameterIndex, Date.valueOf((String)x));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTime(parameterIndex, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof Date) {
                    this.setTime(parameterIndex, new Time(((Date)x).getTime()));
                    break;
                }
                if (x instanceof String) {
                    this.setTime(parameterIndex, Time.valueOf((String)x));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDate(parameterIndex, (Date)x);
                    break;
                }
                if (x instanceof String) {
                    this.setTimestamp(parameterIndex, Timestamp.valueOf((String)x));
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 2004: {
                if (x instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)x);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            case 2005: {
                if (x instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)x);
                    break;
                }
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
            default: {
                throw new TbSQLException(-590704, "" + targetSqlType);
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObject(parameterIndex, x, DataType.getSqlType(x));
    }

    public void setTbObject(int parameterIndex, Object x, int dataType) throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (x == null) {
            this.setNullInternal(parameterIndex, dataType);
            return;
        }
        byte[] bytes = this.conn.typeConverter.fromObject(x);
        this.bind(parameterIndex, bytes.length, bytes, dataType);
    }

    public void setBatchBufferSize(int batchBufferSize) {
        this.batchBufferSize = batchBufferSize + extraBatchSize;
    }

    private void storeBindValues() throws SQLException {
        boolean isFirstAddBatch = false;
        if (this.batchWriter == null) {
            isFirstAddBatch = true;
            this.batchWriter = new TbBatchStreamDataWriter(new StreamBuffer(this.batchBufferSize), this.conn.typeConverter);
            this.batchWriter.setSql(this.originalSql);
            this.batchWriter.setCurDataSize(this.batchWriter.getHeaderSize());
            this.bindParamDataType = new int[this.bindParamCnt];
        }
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem bindItem = this.bindData.getBindItem(i);
            int kind = bindItem.getKind();
            int exDataType = bindItem.getExDataType();
            if (kind == 2 || kind == 4) {
                throw new TbSQLException(-90631);
            }
            if (kind == 8) {
                throw new TbSQLException(-90636);
            }
            if (!bindItem.isBinded()) {
                throw new TbSQLException(-90627);
            }
            if (!bindItem.isNull()) {
                this.batchWriter.writeStreamBuffer(kind, exDataType, (byte[])bindItem.getRawData().getData());
            } else {
                this.batchWriter.writeStreamBuffer(kind, exDataType, null);
            }
            if (this.flag != 256) continue;
            if (isFirstAddBatch) {
                this.bindParamDataType[i] = exDataType;
                continue;
            }
            if (this.bindParamDataType[i] == exDataType) continue;
            this.flag = 0;
        }
    }

    public void addBatch() throws SQLException {
        this.storeBindValues();
        int curParamInfoSize = this.batchWriter.getBufferedDataSize() - this.batchWriter.getHeaderSize() - this.prevParamInfoSize;
        ++this.totBatchRowCnt;
        if (curParamInfoSize >= DBConst.BATCH_SEND_SIZE) {
            int bindParamSum = this.totBatchRowCnt * this.bindParamCnt;
            this.batchInfoList.add(new BatchInfo(bindParamSum - this.prevBindParamSum, this.totBatchRowCnt - this.prevBatchRowCnt, curParamInfoSize));
            this.prevBindParamSum = bindParamSum;
            this.prevBatchRowCnt = this.totBatchRowCnt;
            this.prevParamInfoSize = this.batchWriter.getBufferedDataSize() - this.batchWriter.getHeaderSize();
        }
    }

    public TbBatchStreamDataWriter getBatchStreamDataWriter() {
        return this.batchWriter;
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs == null) {
            throw new TbSQLException(-90607);
        }
        return rs.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public byte[] getPPID() {
        return this.ppid;
    }

    public void setPPID(byte[] ppid) {
        this.ppid = ppid;
    }

    public boolean getPreparedDDLFlag() {
        return this.preparedDDL;
    }

    public void setPreparedDDLFlag(boolean flag) {
        this.preparedDDL = flag;
    }

    public int getParameterCnt() {
        return this.bindParamCnt;
    }

    public void setParameterCnt(int cnt) {
        this.bindParamCnt = cnt;
    }

    public BindData getBindData() {
        return this.bindData;
    }

    public void setBindData(BindData bindData) {
        this.bindData = bindData;
    }

    public void buildColMetaArray(int colCnt, int hiddenColCnt, TbColumnDesc[] colMeta) {
        this.outColCnt = colCnt;
        this.hiddenColCnt = hiddenColCnt;
        this.colMeta = colMeta;
    }

    public TbColumnDesc[] getColMetaArray() {
        return this.colMeta;
    }

    public int getHiddenColCnt() {
        return this.hiddenColCnt;
    }

    public int getOutColCnt() {
        return this.outColCnt;
    }

    protected void checkParameterIndex(int pos) throws SQLException {
        if (pos < 0 || pos > this.bindData.getParameterCnt()) {
            throw new TbSQLException(-90609);
        }
    }

    protected synchronized void bind(int parameterIndex, int length, byte[] bytes, int dataType) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setBindItem(parameterIndex - 1, 1, length, bytes, dataType);
    }

    protected synchronized void bind(int parameterIndex, int length, int dataType, Reader rawDataReader) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setBindItem(parameterIndex - 1, 8, length, rawDataReader, dataType);
    }

    protected synchronized void bind(int parameterIndex, int length, int dataType, InputStream binaryStream) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setBindItem(parameterIndex - 1, 8, length, binaryStream, dataType);
    }

    protected synchronized void bindDeferredBytes(int paramterIndex, int length, byte[] bytes, int dataType) throws SQLException {
        this.checkParameterIndex(paramterIndex);
        this.bindData.setBindItem(paramterIndex - 1, 8, length, bytes, dataType);
    }

    protected synchronized void bindDeferredChars(int paramterIndex, int length, char[] chars, int dataType) throws SQLException {
        this.checkParameterIndex(paramterIndex);
        this.bindData.setBindItem(paramterIndex - 1, 8, length, chars, dataType);
    }

    protected synchronized void bindSetNull(int parameterIndex, int dataType) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setBindItemNull(parameterIndex - 1, 1, dataType);
    }

    public void initParameter() throws SQLException {
        this.bindParamCnt = TbSqlParser.getParamCount(this.originalSql);
        this.bindData = new BindData(this.bindParamCnt);
    }

    protected synchronized TbResultSet executeInternal(String sql) throws SQLException {
        TbResultSet rs = null;
        if (this.sqlType == 1 && (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008)) {
            this.sqlWithRowId = this.getQueryWithRowId(this.originalSql);
            try {
                this.realRsetType = this.userRsetType;
                rs = this.conn.getTbComm().prepareExecute(this, this.sqlWithRowId);
            }
            catch (SQLException se) {
                this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                rs = this.conn.getTbComm().prepareExecute(this, this.originalSql);
            }
        } else {
            this.realRsetType = this.userRsetType;
            rs = this.conn.getTbComm().prepareExecute(this, this.originalSql);
        }
        if (rs instanceof TbRSEmpty) {
            TbStatementLogger.logRecoveryStatement(this, this.conn.getTypeConverter());
        }
        return rs;
    }

    public void copyBindData(BindData src) throws SQLException {
        BindData dstBindData = this.bindData;
        if (src != null) {
            int srcParamCnt = src.getParameterCnt();
            for (int cnt = 0; cnt < srcParamCnt; ++cnt) {
                BindItem item = src.getBindItem(cnt);
                if (item == null) continue;
                RawData rawData = item.getRawData();
                dstBindData.setBindItem(cnt, item.getKind(), rawData.getLength(), (byte[])rawData.getData(), item.getExDataType());
            }
        }
    }

    protected void checkBatchBindRemained() throws SQLException {
        if (this.totBatchRowCnt > 0) {
            throw new TbSQLException(-90606);
        }
    }

    protected void setNullInternal(int parameterIndex, int dataType) throws SQLException {
        this.bindSetNull(parameterIndex, dataType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public void setFormOfUse(int parameterIndex, short form) throws SQLException {
        this.checkParameterIndex(parameterIndex);
        this.bindData.setFormOfUse(parameterIndex - 1, form);
    }

    private short getFormOfUse(int parameterIndex) {
        if (this.bindData == null) {
            return 0;
        }
        return this.bindData.getFormOfUse(parameterIndex - 1);
    }

    public boolean isCachedStmt() {
        return this.isCachedStmt;
    }

    public void setCachedStmt(boolean isCachedStmt) {
        this.isCachedStmt = isCachedStmt;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new TbParameterMetaData(this.bindParamCnt);
    }
}

