/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbRSEmpty;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbResultSetBase;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RowChunkMgr;
import com.tmax.tibero.jdbc.data.RsetBuilder;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.util.TbSqlParser;
import com.tmax.tibero.jdbc.util.TbSqlTypeScanner;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TbStatement
implements Statement {
    protected int queryTimeout = 0;
    protected int fetchDirection = 1000;
    protected int maxRow = 0;
    protected int sqlType = 0;
    protected TbConnection conn = null;
    protected RsetType userRsetType = null;
    protected RsetType realRsetType = null;
    protected String originalSql = null;
    protected String sqlWithRowId = null;
    protected SQLWarning warnings;
    protected TbSqlTypeScanner sqlTypeScanner;
    protected boolean enableEscapeProcessing = true;
    private boolean closed;
    protected boolean isExecuting;
    private RowChunkMgr rowChunkMgr;
    protected List batchStmts = null;
    protected TbResultSet rs = null;
    protected Row[] rows = null;
    protected int curCsrId = -1;
    protected int maxFieldSize = 65535;
    protected int preFetchSize;
    protected int fetchSize = this.preFetchSize = 50;
    protected int[] batchCounts = null;
    protected TbPivotInfo[] pivotInfo = null;
    protected Vector pivotData = new Vector();

    public TbStatement(TbConnection conn) {
        this(conn, 1003, 1007, 50);
    }

    public TbStatement(TbConnection conn, int rsetType, int rsetConcurrency, int preFetchSize) {
        this.conn = conn;
        this.userRsetType = RsetType.getRsetType(rsetType, rsetConcurrency);
        this.preFetchSize = preFetchSize;
        this.fetchSize = preFetchSize;
        this.closed = false;
        this.isExecuting = false;
    }

    protected void reset() {
        this.closed = true;
        this.warnings = null;
        this.conn = null;
        this.userRsetType = null;
        if (this.rowChunkMgr != null) {
            this.rowChunkMgr.reset();
        }
        if (this.batchStmts != null) {
            this.batchStmts.clear();
        }
        this.rowChunkMgr = null;
        this.rs = null;
        this.rows = null;
        this.batchStmts = null;
        this.batchCounts = null;
    }

    protected void resetForCache() {
        this.rs = null;
        this.batchCounts = null;
        this.warnings = null;
        if (this.rowChunkMgr != null) {
            this.rowChunkMgr.reset();
            this.rowChunkMgr = null;
        }
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    public void reuse() {
        this.warnings = null;
        this.enableEscapeProcessing = true;
        this.queryTimeout = 0;
        this.maxRow = 0;
        this.originalSql = null;
        this.rs = null;
        this.batchCounts = null;
        this.batchStmts.clear();
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("\n\t==== TbStatement[").append(super.toString());
        buf.append("] ====");
        buf.append(" conn[").append(this.conn).append("]");
        buf.append(" orginalSql[").append(this.originalSql).append("]");
        buf.append(" fetchSize[").append(this.fetchSize).append("]");
        buf.append(" useRowId[").append(this.userRsetType.useRowId()).append("]");
        buf.append(" rsetType[").append(this.userRsetType).append("]");
        buf.append(" fetchDirection[").append(this.fetchDirection).append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        try {
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            this.rs = this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.rs == null) {
            throw new TbSQLException(-90607);
        }
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String sql) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            this.rs = this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.rs == null) {
            throw new TbSQLException(-90607);
        }
        return (int)this.rs.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        try {
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.reset();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max <= 0) {
            throw new TbSQLException(-90608);
        }
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRow;
    }

    public synchronized void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new TbSQLException(-90608, "value should be greater or equal to 0");
        }
        this.maxRow = max;
    }

    public synchronized void setEscapeProcessing(boolean enable) throws SQLException {
        this.enableEscapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new TbSQLException(-90608, "value should be greater or equal to 0");
        }
        this.queryTimeout = seconds;
    }

    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.isExecuting) {
            this.conn.getTbComm().cancelStatement();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void setCursorName(String name) throws SQLException {
        throw new TbSQLException(-90201, "Statement.setCursorName()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String sql) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            this.rs = this.executeInternal(sql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.rs == null) {
            throw new TbSQLException(-90607);
        }
        return !(this.rs instanceof TbRSEmpty);
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.rs != null && RsetBuilder.RSET.equals(this.rs.getRsetBuilder())) {
            return this.rs;
        }
        return null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.rs != null && (RsetBuilder.COUNT.equals(this.rs.getRsetBuilder()) || RsetBuilder.JUSTOK.equals(this.rs.getRsetBuilder()))) {
            return (int)this.rs.getUpdateCount();
        }
        if (this.batchCounts != null) {
            int updateCount = 0;
            for (int i = 0; i < this.batchCounts.length; ++i) {
                updateCount += this.batchCounts[i];
            }
            return updateCount;
        }
        return -1;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        return false;
    }

    public synchronized void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
            }
        }
        throw new TbSQLException(-90608, "setFetchDirection");
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public synchronized void setFetchSize(int rows) throws SQLException {
        if (rows == 0) {
            this.fetchSize = 50;
        } else if (rows > 0) {
            this.fetchSize = rows;
        } else {
            throw new TbSQLException(-90608, "setFetchSize");
        }
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() {
        return this.userRsetType.getConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.userRsetType.getType();
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchStmts == null) {
            this.batchStmts = new ArrayList();
        }
        this.batchStmts.add(sql);
    }

    public synchronized void clearBatch() throws SQLException {
        this.batchStmts.clear();
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.checkConnectionOpen();
        this.initBeforeExecute();
        int size = this.batchStmts.size();
        if (size <= 0) {
            return new int[0];
        }
        this.batchCounts = new int[size];
        int i = 0;
        try {
            Object rs;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            for (i = 0; i < size; ++i) {
                rs = this.executeInternal((String)this.batchStmts.get(i));
                if (rs == null || RsetBuilder.RSET.equals(((TbResultSet)rs).getRsetBuilder())) {
                    throw new TbSQLException(-90630);
                }
                this.batchCounts[i] = (int)((TbResultSet)rs).getUpdateCount();
            }
            rs = this.batchCounts;
            return rs;
        }
        catch (TbSQLException e) {
            int[] newResultCount = new int[i];
            System.arraycopy(this.batchCounts, 0, newResultCount, 0, i);
            this.batchCounts = newResultCount;
            BatchUpdateException bue = new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), this.batchCounts);
            throw bue;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkConnectionOpen();
        return this.conn;
    }

    protected synchronized TbResultSet executeInternal(String sql) throws SQLException {
        this.originalSql = this.getOriginalSql(sql);
        this.sqlTypeScanner = new TbSqlTypeScanner();
        this.sqlType = this.sqlTypeScanner.getSqlType(this.originalSql);
        TbResultSet rs = null;
        if (this.sqlType == 1 && (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008)) {
            this.sqlWithRowId = this.getQueryWithRowId(this.originalSql);
            try {
                this.realRsetType = this.userRsetType;
                rs = this.conn.getTbComm().executeDirect(this, this.sqlWithRowId);
            }
            catch (SQLException se) {
                this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                rs = this.conn.getTbComm().executeDirect(this, this.originalSql);
            }
        } else {
            this.realRsetType = this.userRsetType;
            rs = this.conn.getTbComm().executeDirect(this, this.originalSql);
        }
        return rs;
    }

    protected String getQueryWithRowId(String sql) {
        StringBuffer sqlBuffer = new StringBuffer(100);
        int index = this.sqlTypeScanner.getCurrentIndex();
        sqlBuffer.append(sql.substring(0, index));
        sqlBuffer.append(" rowid, ");
        sqlBuffer.append(sql.substring(index));
        return sqlBuffer.toString();
    }

    protected void initBatchStmts() {
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    protected void initBeforeExecute() throws SQLException {
        this.batchCounts = null;
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
    }

    protected void checkConnectionOpen() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw new TbSQLException(-90603);
        }
    }

    protected synchronized void closeResultSet() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        if (this.rows != null) {
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i].close();
                this.rows[i] = null;
            }
            this.rows = null;
        }
    }

    protected void setResultSet(TbResultSet resultSet) {
        this.rs = resultSet;
    }

    public synchronized Row[] fetch(TbResultSetBase rs) throws SQLException {
        return this.conn.getTbComm().fetch(this, rs);
    }

    protected void checkBatchStmtRemained() throws SQLException {
        if (this.batchStmts.size() > 0) {
            throw new TbSQLException(-90606);
        }
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public String getSqlWithRowId() {
        return this.sqlWithRowId;
    }

    public RsetType getRealRsetType() {
        return this.realRsetType;
    }

    protected String getOriginalSql(String sql) throws SQLException {
        if (sql == null || sql.length() <= 0) {
            throw new TbSQLException(-90608, "SQL is null");
        }
        if (this.enableEscapeProcessing && sql.indexOf(123) >= 0) {
            return TbSqlParser.parse(sql);
        }
        if (sql.indexOf(63) > 0) {
            return TbSqlParser.replace(sql);
        }
        return sql;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getCurCsrId() {
        return this.curCsrId;
    }

    public void setCurCsrId(int csrId) {
        this.curCsrId = csrId;
    }

    public RowChunkMgr getRowChunkMgr() {
        if (this.rowChunkMgr != null) {
            return this.rowChunkMgr;
        }
        this.rowChunkMgr = new RowChunkMgr();
        return this.rowChunkMgr;
    }

    public synchronized void setRowPreFetch(int preFetchSize) throws SQLException {
        if (preFetchSize < 0) {
            throw new TbSQLException(-90608, "setPreFetchSize");
        }
        this.preFetchSize = preFetchSize;
        if (preFetchSize == 0) {
            this.setFetchSize(50);
        } else {
            this.setFetchSize(preFetchSize);
        }
    }

    public int getPreFetchSize() {
        if (this.getSqlType() == 1 && this.getRealRsetType().getType() != 1005) {
            return this.preFetchSize;
        }
        return 0;
    }

    public TbPivotInfo[] getPivotInfo() {
        return this.pivotInfo;
    }

    public void setPivotInfo(TbPivotInfo[] pivotInfo) {
        this.pivotInfo = pivotInfo;
    }

    public Vector getPivotData() {
        return this.pivotData;
    }

    public void addPivotData(byte[] data) {
        this.pivotData.add(data);
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new TbSQLException(-90201);
    }

    public int getResultSetHoldability() throws SQLException {
        throw new TbSQLException(-90201);
    }
}

