/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.msg.TbMsgAuthReqWithVer;
import com.tmax.tibero.jdbc.msg.TbMsgConnectReply;
import com.tmax.tibero.jdbc.msg.TbMsgSessInfoReply;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

class TbLogOn {
    TbStream stream;
    TbConnection conn;

    public TbLogOn(TbConnection conn, TbStream stream) {
        this.conn = conn;
        this.stream = stream;
    }

    private void doAuthError(TbMsg msg) throws SQLException {
        throw this.conn.getTbComm().getErrorMessage(-90502, msg);
    }

    private void doAuthReplyOK(TbMsgSessInfoReply msg) {
        this.conn.setSessionId(msg.sessionId);
        this.conn.setSerialNo(msg.serialNo);
        this.conn.setNlsDate(msg.nlsDate);
        this.conn.setNlsTimestamp(msg.nlsTimestamp);
    }

    private void doAuthRequest() throws SQLException {
        String dbname;
        TbStream stream = this.stream;
        TbMsgAuthReqWithVer msg = new TbMsgAuthReqWithVer(0);
        String username = this.conn.info.getUser();
        String passwd = this.conn.info.getPassword();
        if (passwd == null) {
            passwd = "";
        }
        dbname = (dbname = this.conn.info.getDatabaseName()).length() >= 2 && dbname.startsWith("\"") && dbname.endsWith("\"") ? dbname.substring(1, dbname.length() - 1) : dbname.toUpperCase();
        msg.set(1, 2, 0, username, dbname, passwd, "", -1, "", "", "", 1);
        stream.sendMsg(msg);
    }

    public synchronized void logon() throws SQLException {
        block5: while (true) {
            TbMsg replyMsg = this.stream.readMsgHdr();
            this.stream.readMsgBody(replyMsg);
            switch (replyMsg.getMsgType()) {
                case 0: {
                    TbMsgConnectReply connectReplyMsg = (TbMsgConnectReply)replyMsg;
                    this.setConnectReplyInfo(connectReplyMsg);
                    this.conn.getTypeConverter().setCharset(this.conn.getServerCharSet(), this.conn.getServerNCharSet());
                    this.doAuthRequest();
                    continue block5;
                }
                case 2: {
                    this.doAuthReplyOK((TbMsgSessInfoReply)replyMsg);
                    this.reset();
                    return;
                }
                case 76: {
                    this.doAuthError(replyMsg);
                    return;
                }
            }
            break;
        }
        throw new TbSQLException(-90402, "Unsupported protocol");
    }

    private void reset() {
        this.stream = null;
        this.conn = null;
    }

    private void setConnectReplyInfo(TbMsgConnectReply msg) {
        ServerInfo info = new ServerInfo(msg.charset, msg.ncharset, msg.svrIsBigendian, msg.svrIsNanobase, msg.tbMajor, msg.tbMinor, msg.tbProductName, msg.tbProductVersion);
        this.conn.setServerInfo(info);
        this.conn.setMthrPid(msg.mthrPid);
    }
}

