/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbBatchStreamDataWriter;
import com.tmax.tibero.jdbc.comm.TbPacketHeader;
import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbMsgFactory;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;

public class TbStream {
    private static final boolean isMock = false;
    private static final int BUF_MODE_READ = 0;
    private static final int BUF_MODE_WRITE = 1;
    private Socket socket;
    private Connection conn;
    private InputStream input;
    private OutputStream output;
    private int tduSize = 0;
    private int msgType;
    private int msgBodySize = 0;
    private TbPacketHeader header = new TbPacketHeader();
    private StreamBuffer buf;
    private TbStreamDataReader reader;
    private TbStreamDataWriter writer;
    private boolean bufWriting;
    private StreamBuffer dplBuf;
    private TbDirPathStreamDataWriter dplWriter;

    public TbStream(Socket socket, int tdu, DataTypeConverter typeConverter) throws SQLException {
        try {
            this.init(socket, tdu, typeConverter);
        }
        catch (IOException ie) {
            throw new TbSQLException(-90400, ie.getMessage());
        }
    }

    public TbStream(Connection conn, String host, int port, int tdu, DataTypeConverter typeConverter) throws SQLException {
        try {
            this.conn = conn;
            this.init(new Socket(host, port), tdu, typeConverter);
        }
        catch (ConnectException ce) {
            throw new TbSQLException(-90401, ce.getMessage());
        }
        catch (IOException ie) {
            ie.printStackTrace();
            throw new TbSQLException(-90400, ie.getMessage());
        }
    }

    public void reset() {
        this.tduSize = 0;
        this.input = null;
        this.output = null;
        this.bufWriting = false;
        this.reader.reset();
        this.writer.reset();
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        buf.append(" socket[").append(this.socket).append("]");
        buf.append(" input[").append(this.input).append("]");
        buf.append(" output[").append(this.output).append("]");
        buf.append(" tdu[").append(this.tduSize).append("]");
        return buf.toString();
    }

    private void init(Socket socket, int tdu, DataTypeConverter typeConverter) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.tduSize = tdu;
        this.buf = new StreamBuffer(this.tduSize);
        this.reader = new TbStreamDataReader(this.buf, typeConverter);
        this.writer = new TbStreamDataWriter(this.buf, typeConverter);
        this.bufWriting = false;
    }

    public void close() throws SQLException {
        try {
            this.reset();
            IOException ioe = null;
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                ioe = e;
            }
            if (ioe != null) {
                throw ioe;
            }
        }
        catch (IOException ie) {
            throw new TbSQLException(-90409, ie.getMessage());
        }
    }

    public int getRealTDUSize() {
        return this.tduSize;
    }

    public TbPacketHeader getPacketHeader() {
        return this.header;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public int getMsgBodySize() {
        return this.msgBodySize;
    }

    private void checkBufferStatus(int mode) throws SQLException {
        if (this.bufWriting ? mode == 0 : mode == 1) {
            throw new TbSQLException(-90404, "stream buffer status is not valid");
        }
    }

    public TbMsg readMsgHdr() throws SQLException {
        byte[] hdrBuf = new byte[24];
        try {
            this._readNBytes(hdrBuf, 0, 24);
        }
        catch (IOException ie) {
            throw new TbSQLException(-90405, ie.getMessage());
        }
        this.msgType = TbCommon.byte2int(hdrBuf, 0, 4);
        this.msgBodySize = TbCommon.byte2int(hdrBuf, 4, 4);
        TbMsg msg = TbMsgFactory.createMessage(this.msgType, 0);
        hdrBuf = null;
        return msg;
    }

    public void readMsgBody(TbMsg msg) throws SQLException {
        this.readMsgBodyFromNet();
        msg.deserialize(this.reader);
    }

    public void readChunkData(StreamBuffer buf, int chunkDataSize) throws SQLException {
        this.checkBufferStatus(0);
        try {
            int curDataSize = buf.getCurDataSize();
            if (this._readNBytes(buf.getRawBytes(), curDataSize, chunkDataSize) != chunkDataSize) {
                throw new TbSQLException(-90405, "reading packet body error");
            }
            buf.setCurDataSize(curDataSize + chunkDataSize);
            this.msgBodySize = 0;
        }
        catch (IOException ie) {
            throw new TbSQLException(-90405, ie.getMessage());
        }
    }

    public void readMsgBody(TbMsg msg, int offsetToDivide, byte[] charPiece, int charPieceLen) throws SQLException {
        this.readMsgBodyFromNet(offsetToDivide, charPiece, charPieceLen);
        msg.deserialize(this.reader);
    }

    public void sendMsg(TbMsg msg) throws SQLException {
        this.startWritingPacketData();
        msg.serialize(this.writer);
        this.flush();
    }

    private int _readNBytes(byte[] bytes, int offset, int len) throws IOException {
        try {
            int totalRead;
            int i = 0;
            for (totalRead = 0; totalRead != len; totalRead += i) {
                i = this.input.read(bytes, offset + totalRead, len - totalRead);
                if (i != -1) continue;
                throw new IOException("End Of Stream");
            }
            return totalRead;
        }
        catch (IOException ie) {
            try {
                this.conn.close();
            }
            catch (SQLException se) {
                // empty catch block
            }
            throw ie;
        }
    }

    public void skipUnreadPacketData() {
        if (this.msgBodySize <= 0) {
            return;
        }
        try {
            this.buf.init(this.msgBodySize);
            this._readNBytes(this.buf.getRawBytes(), 0, this.msgBodySize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TbStreamDataReader readMsgBodyFromNet() throws SQLException {
        return this.readMsgBodyFromNet(this.buf);
    }

    public TbStreamDataReader readMsgBodyFromNet(StreamBuffer buf) throws SQLException {
        this.checkBufferStatus(0);
        if (this.msgBodySize <= 0) {
            return null;
        }
        try {
            buf.init(this.msgBodySize);
            if (this._readNBytes(buf.getRawBytes(), 0, this.msgBodySize) != this.msgBodySize) {
                throw new TbSQLException(-90405, "reading packet body error");
            }
            buf.setCurDataSize(this.msgBodySize);
            this.reader.initialize(buf);
            this.msgBodySize = 0;
            return this.reader;
        }
        catch (IOException ie) {
            throw new TbSQLException(-90405, ie.getMessage());
        }
    }

    public TbStreamDataReader readMsgBodyFromNet(int offsetToDivide, byte[] charPiece, int charPieceLen) throws SQLException {
        this.checkBufferStatus(0);
        if (this.msgBodySize <= 0) {
            return null;
        }
        try {
            this.buf.init(this.msgBodySize + charPieceLen);
            if (charPieceLen != 0) {
                if (this._readNBytes(this.buf.getRawBytes(), 0, offsetToDivide) != offsetToDivide) {
                    throw new TbSQLException(-90405, "reading packet data error");
                }
                int dataSize = TbCommon.byte2int(this.buf.getRawBytes(), offsetToDivide - 4, 4);
                TbCommon.int2bytes(dataSize + charPieceLen, this.buf.getRawBytes(), offsetToDivide - 4, 4);
                System.arraycopy(charPiece, 0, this.buf.getRawBytes(), offsetToDivide, charPieceLen);
                if (this._readNBytes(this.buf.getRawBytes(), offsetToDivide + charPieceLen, this.msgBodySize - offsetToDivide) != this.msgBodySize - offsetToDivide) {
                    throw new TbSQLException(-90405, "reading packet data error");
                }
            } else if (this._readNBytes(this.buf.getRawBytes(), 0, this.msgBodySize) != this.msgBodySize) {
                throw new TbSQLException(-90405, "reading packet data error");
            }
            this.buf.setCurDataSize(this.msgBodySize + charPieceLen);
            this.reader.initialize(this.buf);
            this.msgBodySize = 0;
            return this.reader;
        }
        catch (IOException ie) {
            throw new TbSQLException(-90405, ie.getMessage());
        }
    }

    public TbStreamDataWriter startWritingPacketData() {
        this.bufWriting = true;
        this.writer.initialize(this.buf);
        return this.writer;
    }

    public void flush() throws SQLException {
        try {
            if (this.buf.getCurDataSize() > 0) {
                this.output.write(this.buf.getRawBytes(), 0, this.buf.getCurDataSize());
                this.output.flush();
            }
            this.bufWriting = false;
        }
        catch (IOException e) {
            throw new TbSQLException(-90406, e.getMessage());
        }
    }

    public void flush(TbStreamDataWriter writer) throws SQLException {
        StreamBuffer buf = writer.getStreamBuf();
        try {
            this.bufWriting = true;
            if (buf.getCurDataSize() > 0) {
                this.output.write(buf.getRawBytes(), 0, buf.getCurDataSize());
                this.output.flush();
            }
            this.bufWriting = false;
        }
        catch (IOException e) {
            throw new TbSQLException(-90406, e.getMessage());
        }
    }

    public void flushBatch(TbBatchStreamDataWriter batchWriter, int offset, int paramInfoSize) throws SQLException {
        StreamBuffer batchBuf = batchWriter.getStreamBuf();
        try {
            if (batchBuf.getCurDataSize() > 0) {
                this.output.write(batchBuf.getRawBytes(), 0, batchWriter.getHeaderSize());
                this.output.flush();
                this.output.write(batchBuf.getRawBytes(), offset, paramInfoSize);
                this.output.flush();
            }
            this.bufWriting = false;
        }
        catch (IOException e) {
            throw new TbSQLException(-90406, e.getMessage());
        }
    }

    public static boolean isMock() {
        return false;
    }

    public TbDirPathStreamDataWriter createDirPathWriter(int initBufSize) {
        if (this.dplBuf == null) {
            this.dplBuf = new StreamBuffer(initBufSize);
        } else {
            int curSize = this.dplBuf.getSize();
            if (curSize != initBufSize) {
                this.dplBuf.resize(initBufSize);
            }
        }
        if (this.dplWriter == null) {
            this.dplWriter = new TbDirPathStreamDataWriter(this.dplBuf);
        }
        return this.dplWriter;
    }
}

