/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataReader {
    private StreamBuffer buf;
    private int curReadOffset;
    private DataTypeConverter typeConverter = null;

    public TbStreamDataReader(StreamBuffer buf, DataTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.initialize(buf);
    }

    public void initialize(StreamBuffer buf) {
        this.buf = buf;
        this.curReadOffset = 0;
    }

    public void reset() {
        this.buf = null;
        this.typeConverter = null;
    }

    public int getCurOffset() {
        return this.curReadOffset;
    }

    public void moveReadOffset(int offset) {
        this.curReadOffset += offset;
    }

    private void isBufferAvailable(int len) throws SQLException {
        if (this.buf == null || this.buf.getCurDataSize() <= 0 || this.buf.getCurDataSize() <= this.curReadOffset || this.buf.getCurDataSize() < this.curReadOffset + len) {
            throw new TbSQLException(-90405, "stream buffer reading error");
        }
    }

    public int getBufferedDataSize() {
        if (this.buf != null) {
            return this.buf.getCurDataSize();
        }
        return 0;
    }

    private void skipPadding(int skipLen) throws SQLException {
        this.isBufferAvailable(skipLen);
        this.moveReadOffset(skipLen);
    }

    public int readInt32() throws SQLException {
        return this.readInt(4);
    }

    public int readInt16() throws SQLException {
        return this.readInt(2);
    }

    public int readInt8() throws SQLException {
        return this.readInt(1);
    }

    private int readInt(int byteLen) throws SQLException {
        this.isBufferAvailable(byteLen);
        int num = TbCommon.byte2int(this.buf.getRawBytes(), this.curReadOffset, byteLen);
        this.moveReadOffset(byteLen);
        return num;
    }

    public long readLong() throws SQLException {
        this.isBufferAvailable(8);
        long num = TbCommon.byte2long(this.buf.getRawBytes(), this.curReadOffset, 8);
        this.moveReadOffset(8);
        return num;
    }

    public byte[] readPadBytes(int realLength) throws SQLException {
        byte[] bytes = new byte[realLength];
        this.readPadBytes(bytes, 0, realLength);
        return bytes;
    }

    public void readPadBytes(byte[] bytes, int offset, int len) throws SQLException {
        this.readBytes(bytes, offset, len);
        int padLen = TbCommon.getPadLength(len);
        this.skipPadding(padLen);
    }

    public void readBytes(byte[] bytes, int offset, int len) throws SQLException {
        this.isBufferAvailable(len);
        System.arraycopy(this.buf.getRawBytes(), this.curReadOffset, bytes, offset, len);
        this.moveReadOffset(len);
    }

    public String readDBDecodedPadString(int byteLen) throws SQLException {
        this.isBufferAvailable(byteLen);
        String str = null;
        if (byteLen > 0) {
            str = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, byteLen);
            this.moveReadOffset(byteLen);
        }
        int padLen = TbCommon.getPadLength(byteLen);
        this.skipPadding(padLen);
        return str;
    }

    public String readDBDecodedString(int byteLen) throws SQLException {
        this.isBufferAvailable(byteLen);
        String str = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, byteLen);
        this.moveReadOffset(byteLen);
        return str;
    }

    public int readCharsFromBytes(int byteLen, char[] charArray, long offset) throws SQLException {
        int readLen = 0;
        this.isBufferAvailable(byteLen);
        readLen = this.typeConverter.bytesToChars(this.buf.getRawBytes(), this.curReadOffset, byteLen, charArray, (int)offset, byteLen);
        return readLen;
    }

    public byte[] readLobLocator() throws SQLException {
        int len = this.readInt(4);
        byte[] locator = new byte[len];
        this.readBytes(locator, 0, len);
        return locator;
    }

    public byte[] readRpcolData() throws SQLException {
        byte[] lenFlag = new byte[1];
        byte[] colData = null;
        this.readBytes(lenFlag, 0, 1);
        if (lenFlag[0] <= -6) {
            byte colLen = lenFlag[0];
            colData = new byte[colLen + 1];
            colData[0] = lenFlag[0];
            this.readBytes(colData, 1, colLen);
        } else if (lenFlag[0] == -2) {
            byte[] colLenByteLarge = new byte[2];
            this.readBytes(colLenByteLarge, 0, 2);
            int colLen = 0xFF & colLenByteLarge[0] << 8;
            colData = new byte[(colLen &= 0xFF & colLenByteLarge[1]) + 3];
            colData[0] = lenFlag[0];
            colData[1] = colLenByteLarge[0];
            colData[2] = colLenByteLarge[1];
            this.readBytes(colData, 3, colLen);
        } else {
            throw new TbSQLException(-90405);
        }
        return colData;
    }
}

