/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

class AttrDesc {
    private String name = "";
    private int sqlType = -1;
    private int dataType = 17;
    private int exDataType = 17;
    private int maxLength = 0;
    private int precision = -1;
    private int scale = -1;
    private boolean isNullable;
    private boolean isPrimaryKey;
    private boolean isMultipleKey;
    private boolean isUniqueKey;

    AttrDesc() {
    }

    public void copyData(AttrDesc src) {
        this.name = src.name;
        this.sqlType = src.sqlType;
        this.dataType = src.dataType;
        this.exDataType = src.exDataType;
        this.maxLength = src.maxLength;
        this.precision = src.precision;
        this.scale = src.scale;
        this.isNullable = src.isNullable;
        this.isPrimaryKey = src.isPrimaryKey;
        this.isMultipleKey = src.isMultipleKey;
        this.isUniqueKey = src.isUniqueKey;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final int getExDataType() {
        return this.exDataType;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final String getName() {
        return this.name == null ? "" : this.name;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final boolean isNullable() {
        return this.isNullable;
    }

    public void reuse() {
        this.name = "";
        this.sqlType = -1;
        this.exDataType = this.dataType;
        this.maxLength = 0;
        this.precision = -1;
        this.scale = -1;
        this.setColumnBitmaps(0);
    }

    public void set(String columnName, int dataType, int maxLength, int precision, int scale, int bitmap) throws SQLException {
        this.name = columnName;
        this.setDataTypeBatch(dataType);
        this.maxLength = maxLength;
        if (DataType.isNumberCategory(dataType)) {
            this.precision = precision;
            this.scale = scale;
        } else {
            this.precision = 0;
            this.scale = 0;
        }
        this.setColumnBitmaps(bitmap);
    }

    protected void setColumnBitmaps(int bitmap) {
        this.isNullable = TbCommon.getBitmapAt(0, bitmap);
        this.isPrimaryKey = TbCommon.getBitmapAt(1, bitmap);
        this.isMultipleKey = TbCommon.getBitmapAt(2, bitmap);
        this.isUniqueKey = TbCommon.getBitmapAt(3, bitmap);
    }

    public final void setDataType(int dataType) {
        try {
            DataType.checkValidDataType(dataType);
            this.dataType = dataType;
        }
        catch (Exception e) {
            this.dataType = 3;
        }
    }

    public final void setDataTypeBatch(int dataType) {
        try {
            DataType.checkValidDataType(dataType);
            if (this.dataType == 17) {
                this.dataType = dataType;
                this.exDataType = dataType;
            }
            this.sqlType = dataType == 16 ? -1 : DataType.getSqlType(dataType);
        }
        catch (Exception e) {
            this.dataType = 3;
            this.exDataType = 3;
            try {
                this.sqlType = DataType.getSqlType(3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void setExDataType(int dataType) {
        try {
            DataType.checkValidDataType(dataType);
            this.exDataType = dataType;
        }
        catch (Exception e) {
            this.exDataType = 3;
        }
    }

    public final void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        buf.append(" columnName[").append(this.name).append("]");
        buf.append(" sqlType[").append(this.sqlType).append("]");
        buf.append(" dataType[").append(this.dataType).append("]");
        buf.append(" maxLength[").append(this.maxLength).append("]");
        buf.append(" precision[").append(this.precision).append("]");
        buf.append(" scale[").append(this.scale).append("]");
        buf.append(" nullable[").append(this.isNullable).append("]");
        buf.append(" primaryKey[").append(this.isPrimaryKey).append("]");
        buf.append(" multipleKey[").append(this.isMultipleKey).append("]");
        buf.append(" uniqueKey[").append(this.isUniqueKey).append("]");
        return buf.toString();
    }
}

