/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.AttrDesc;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.SQLException;

public class BindItem {
    private AttrDesc itemDesc = new AttrDesc();
    private int kind = 0;
    private boolean isNull = true;
    private boolean isBinded = false;
    private RawData rawData = null;
    private short form = 0;
    private TbColumnDesc[] colMeta;

    public void reuse() {
        this.itemDesc.reuse();
        this.kind = 0;
        this.rawData = null;
        this.isNull = true;
        this.isBinded = false;
        this.form = 0;
        if (this.colMeta != null) {
            this.colMetaClear();
        }
        this.colMeta = null;
    }

    public void close() {
        this.itemDesc = null;
        this.rawData = null;
        if (this.colMeta != null) {
            this.colMetaClear();
            this.colMeta = null;
        }
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BindItem ");
        buf.append(" kind[").append(this.kind).append("] ");
        buf.append(" isNull[").append(this.isNull).append("] ");
        buf.append(" isBinded[").append(this.isBinded).append("] ");
        buf.append(this.itemDesc.toString());
        return buf.toString();
    }

    public void setColMeta(TbColumnDesc[] colMeta) {
        this.colMeta = colMeta;
    }

    public TbColumnDesc[] getColMeta() {
        return this.colMeta;
    }

    private void colMetaClear() {
        for (int i = 0; i < this.colMeta.length; ++i) {
            this.colMeta[i] = null;
        }
    }

    public void setData(int kind, int length, Object data, int dataType) throws SQLException {
        this.setExDataType(dataType);
        this.setKind(kind);
        if (length <= 0) {
            this.rawData = new RawData(length, data);
            this.isNull = true;
        } else {
            this.rawData = new RawData(length, data);
            this.isNull = false;
        }
        this.isBinded = true;
    }

    public void set(int kind, int sqlType) throws SQLException {
        this.setSqlType(sqlType);
        this.setKind(kind);
        this.isBinded = true;
    }

    public void setKind(int kind) {
        this.kind = this.kind == 1 && kind == 2 || this.kind == 2 && kind == 1 ? 4 : kind;
    }

    public RawData getRawData() {
        return this.rawData;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isInParameterOn() {
        return this.kind == 1 || this.kind == 4;
    }

    public boolean isOutParameterOn() {
        return this.kind == 2 || this.kind == 4;
    }

    public boolean isInOutParameterOn() {
        return this.kind == 4;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public final boolean isBinded() {
        return this.isBinded;
    }

    public short getForm() {
        return this.form;
    }

    public void setForm(short form) {
        this.form = form;
    }

    public final void setDataType(int dataType) {
        this.itemDesc.setDataType(dataType);
    }

    public final void setExDataType(int dataType) {
        this.itemDesc.setExDataType(dataType);
    }

    public final void setSqlType(int sqlType) {
        this.itemDesc.setSqlType(sqlType);
    }

    public final int getExDataType() {
        return this.itemDesc.getExDataType();
    }

    public final int getSqlType() {
        return this.itemDesc.getSqlType();
    }
}

