/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.RawData;
import com.tmax.tibero.jdbc.data.RowChunkMgr;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class Row {
    private RawData[] columnArray = null;
    private int colCnt = 0;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;

    public Row(int colCnt) {
        this.colCnt = colCnt;
        this.makeRawDataArray(colCnt);
    }

    public Row(int colCnt, int arrayCnt) {
        this.colCnt = colCnt;
        this.makeRawDataArray(arrayCnt);
    }

    public int buildRowData(RowChunkMgr rowChunkMgr, byte[] rawBytes, int bufOffset, Column[] cols) {
        int ptr = bufOffset + 3;
        for (int i = 0; i < this.colCnt; ++i) {
            int len = TbCommon.byte2int(rawBytes, ptr, 1);
            if (len <= 250) {
                ++ptr;
            } else {
                len = TbCommon.byte2int(rawBytes, ptr + 1, 2);
                ptr += 3;
            }
            byte[] data = null;
            if (cols[i].getDataType() == 1 && len > 0) {
                data = new byte[len + 1];
                System.arraycopy(rawBytes, ptr - 1, data, 0, len + 1);
                this.columnArray[i].setLength(len + 1);
            } else {
                data = new byte[len];
                System.arraycopy(rawBytes, ptr, data, 0, len);
                this.columnArray[i].setLength(len);
            }
            this.columnArray[i].setData(data);
            if (len < 0) continue;
            ptr += len;
        }
        return ptr - bufOffset;
    }

    public int buildRowMetaData(byte[] rawBytes, int bufOffset, int columnCnt, boolean useRowId) {
        int revisedColumnCnt;
        int length = TbCommon.byte2int(rawBytes, bufOffset, 4);
        this.colCnt = revisedColumnCnt = useRowId ? columnCnt : columnCnt + 1;
        int ptr = bufOffset + 4;
        for (int i = 0; i < revisedColumnCnt; ++i) {
            this.columnArray[i].setData(rawBytes);
            if (!useRowId && i == 0) {
                this.columnArray[i].setLength(0);
                continue;
            }
            int len = TbCommon.byte2int(rawBytes, ptr, 4);
            this.columnArray[i].setLength(len);
            ptr += 4;
            if (len < 0) continue;
            ptr += len + (4 - len % 4) % 4;
        }
        return length + 4;
    }

    private void checkIndex(int pos) throws SQLException {
        if (pos > this.colCnt || pos < 0) {
            throw new TbSQLException(-90609);
        }
    }

    public void close() {
        this.colCnt = 0;
        if (this.columnArray != null) {
            for (int i = 0; i < this.columnArray.length; ++i) {
                this.columnArray[i] = null;
            }
            this.columnArray = null;
        }
    }

    public int getColCnt() {
        return this.colCnt;
    }

    public byte[] getRawBytes(int pos) throws SQLException {
        this.checkIndex(pos);
        int len = this.isNull(pos) ? 0 : this.columnArray[pos - 1].getLength();
        byte[] bytes = new byte[len];
        Object data = this.columnArray[pos - 1].getData();
        if (!(data instanceof byte[])) {
            throw new TbSQLException(-590705, " cannot convert to byte array");
        }
        System.arraycopy(data, 0, bytes, 0, len);
        return bytes;
    }

    public RawData getRawData(int pos) throws SQLException {
        this.checkIndex(pos);
        return this.columnArray[pos - 1];
    }

    public int getRawDataCnt() {
        return this.columnArray == null ? 0 : this.columnArray.length;
    }

    public void growRawDataArray(int newColCnt) {
        RawData[] tmp = this.columnArray;
        this.columnArray = new RawData[newColCnt];
        System.arraycopy(tmp, 0, this.columnArray, 0, tmp.length);
        for (int i = this.colCnt; i < newColCnt; ++i) {
            this.columnArray[i] = new RawData();
        }
        this.colCnt = newColCnt;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public boolean isNull(int pos) throws SQLException {
        this.checkIndex(pos);
        int length = this.columnArray[pos - 1].getLength();
        Object data = this.columnArray[pos - 1].getData();
        return length <= 0 || data == null;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    private void makeRawDataArray(int colCnt) {
        int start = 0;
        if (this.columnArray == null) {
            this.columnArray = new RawData[colCnt];
        } else if (this.columnArray.length < colCnt) {
            RawData[] tmp = this.columnArray;
            this.columnArray = new RawData[colCnt];
            System.arraycopy(tmp, 0, this.columnArray, 0, tmp.length);
            start = tmp.length;
        } else {
            start = colCnt;
        }
        for (int i = start; i < colCnt; ++i) {
            this.columnArray[i] = new RawData();
        }
    }

    public void reset() {
        this.deleted = false;
        this.updated = false;
        this.inserted = false;
    }

    public void setColCnt(int colCnt) {
        this.colCnt = colCnt;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public void setRawData(int pos, RawData rawData) throws SQLException {
        this.checkIndex(pos);
        this.columnArray[pos - 1] = rawData;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" cnt(").append(this.colCnt).append(")");
        return buf.toString();
    }
}

