/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

public class StreamBuffer {
    private byte[] rawBytes;
    private int initSize;
    private int curSize;
    private int curDataSize;

    public StreamBuffer(int initSize) {
        this.rawBytes = new byte[initSize];
        this.initSize = initSize;
        this.curSize = initSize;
        this.curDataSize = 0;
    }

    public void addDataSize(int offset) {
        this.curDataSize += offset;
    }

    public void copyRowData(int size, int dataStartOffset, byte[] data) throws IndexOutOfBoundsException, ArrayStoreException, NullPointerException {
        this.makeBufferAvailable(size);
        System.arraycopy(data, dataStartOffset, this.rawBytes, this.curDataSize, size);
        this.addDataSize(size);
    }

    public void delete() {
        this.initSize = 0;
        this.remove();
    }

    public int getCurDataSize() {
        return this.curDataSize;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getRemained() {
        return this.curSize - this.curDataSize;
    }

    public int getSize() {
        return this.curSize;
    }

    public void grow(int len) {
        int newSize;
        if (this.curSize > len) {
            return;
        }
        for (newSize = this.curSize; newSize <= len; newSize *= 2) {
        }
        byte[] newBuf = new byte[newSize];
        System.arraycopy(this.rawBytes, 0, newBuf, 0, this.curDataSize);
        this.rawBytes = null;
        this.rawBytes = newBuf;
        this.curSize = newSize;
    }

    public void growDoubleUp(int len) {
        int newSize = len > this.curSize ? len + this.curSize : this.curSize * 2;
        byte[] oldBuf = this.rawBytes;
        this.rawBytes = new byte[newSize];
        System.arraycopy(oldBuf, 0, this.rawBytes, 0, this.curDataSize);
        oldBuf = null;
        this.curSize = newSize;
    }

    public void init() {
        this.curDataSize = 0;
        if (this.curSize != this.initSize) {
            this.resize(this.initSize);
        }
    }

    public void init(int size) {
        if (this.initSize < size) {
            this.resize(size);
        } else {
            this.init();
        }
    }

    public void makeBufferAvailable(int len) {
        if (this.curDataSize + len > this.curSize) {
            this.growDoubleUp(len);
        }
    }

    public void putData(int size, byte ch) {
        this.makeBufferAvailable(size);
        for (int i = 0; i < size; ++i) {
            this.rawBytes[this.curDataSize + i] = ch;
        }
        this.addDataSize(size);
    }

    public void remove() {
        this.rawBytes = null;
        this.curSize = 0;
        this.curDataSize = 0;
    }

    public void resize(int size) {
        this.rawBytes = null;
        this.rawBytes = new byte[size];
        this.curSize = size;
        this.curDataSize = 0;
    }

    public void setCurDataSize(int dataSize) {
        this.curDataSize = dataSize;
    }
}

