/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.UTF16CharToByteConverter;
import java.sql.SQLException;

public class UTF16Encoder
implements CharsetEncoder {
    private UTF16CharToByteConverter conv = new UTF16CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        return this.conv.convert(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        throw new TbSQLException(-590714);
    }

    public int getEndingBytePos(byte[] byteArr, int offset) {
        return offset % 2 == 0 ? offset + 1 : offset;
    }

    public int getLeadingBytePos(byte[] byteArr, int offset) {
        return offset % 2 == 0 ? offset : offset - 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byteArr, int offset) {
        return offset % 2 != 0;
    }

    public boolean isLeadingByte(byte[] byteArr, int offset) {
        return offset % 2 == 0;
    }

    public byte[] stringToBytes(String srcStr) throws SQLException {
        char[] srcArr = srcStr.toCharArray();
        byte[] temp = new byte[srcArr.length * this.getMaxBytesPerChar()];
        int byteLen = this.charsToBytes(srcArr, 0, srcArr.length, temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    public byte[] stringToFixedBytes(String string) throws SQLException {
        return new byte[0];
    }
}

