/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class TbPooledConnection
implements PooledConnection,
TbConnectionEventHandler {
    protected HashMap eventMap = new HashMap();
    private TbLogicalConnection logicalConn = null;
    private TbConnection physicalConn = null;

    public TbPooledConnection(TbConnection conn) {
        this.setPhysicalConnection(conn);
    }

    public final void addConnectionEventListener(ConnectionEventListener eventListener) {
        if (eventListener != null && this.getPhysicalConnection() != null && this.eventMap != null) {
            this.eventMap.put(eventListener, eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        try {
            this.getPhysicalConnection().close();
        }
        finally {
            this.reset();
        }
    }

    public final Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            TbSQLException sqe = new TbSQLException(-590709);
            this.notifyExceptionEvent(sqe);
            return null;
        }
        try {
            TbLogicalConnection logicalConnection = this.getLogicalConnection();
            if (logicalConnection != null && !logicalConnection.isClosed()) {
                this.getLogicalConnection().close();
            }
            this.setLogicalConnection(this.getNewLogicalConnection());
        }
        catch (SQLException sqe) {
            this.notifyExceptionEvent(sqe);
            throw sqe;
        }
        return this.logicalConn;
    }

    protected final TbLogicalConnection getLogicalConnection() {
        return this.logicalConn;
    }

    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), false);
    }

    protected final TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    public final void notifyClosedEvent() {
        if (this.getPhysicalConnection() != null && this.eventMap != null) {
            Iterator itr = this.eventMap.keySet().iterator();
            while (itr.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)this.eventMap.get(itr.next());
                listener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }

    public final void notifyExceptionEvent(SQLException sqe) {
        if (this.getPhysicalConnection() != null && this.eventMap != null) {
            Iterator itr = this.eventMap.keySet().iterator();
            while (itr.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)this.eventMap.get(itr.next());
                listener.connectionErrorOccurred(new ConnectionEvent(this, sqe));
            }
        }
    }

    public final void removeConnectionEventListener(ConnectionEventListener eventListener) {
        if (eventListener != null && this.getPhysicalConnection() != null && this.eventMap != null) {
            this.eventMap.remove(eventListener);
        }
    }

    public void reset() {
        this.eventMap = null;
        if (this.getLogicalConnection() != null) {
            try {
                this.getLogicalConnection().close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (this.getPhysicalConnection() != null) {
            try {
                this.getPhysicalConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void setLogicalConnection(TbLogicalConnection conn) {
        this.logicalConn = conn;
    }

    protected final void setPhysicalConnection(TbConnection conn) {
        this.physicalConn = conn;
    }
}

