/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindparam;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgBatchUpdate
extends TbMsg {
    public byte[] ppid = new byte[8];
    public int totalArrayCnt;
    public int arrayBindingCnt;
    public int bindParamCnt;
    public int flag;
    public int paramInfoArrayCnt;
    public TbBindparam[] paramInfo;

    public TbMsgBatchUpdate(int autoCommit) {
        this.msgType = 30;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] ppid, int totalArrayCnt, int arrayBindingCnt, int bindParamCnt, int flag, int paramInfoArrayCnt, TbBindparam[] paramInfo) {
        this.ppid = ppid;
        this.totalArrayCnt = totalArrayCnt;
        this.arrayBindingCnt = arrayBindingCnt;
        this.bindParamCnt = bindParamCnt;
        this.flag = flag;
        this.paramInfoArrayCnt = paramInfoArrayCnt;
        this.paramInfo = paramInfo;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeBytes(this.ppid);
        writer.writeInt(this.totalArrayCnt, 4);
        writer.writeInt(this.arrayBindingCnt, 4);
        writer.writeInt(this.bindParamCnt, 4);
        writer.writeInt(this.flag, 4);
        writer.writeInt(this.paramInfoArrayCnt, 4);
        if (this.paramInfo != null) {
            for (int i = 0; i < this.paramInfoArrayCnt; ++i) {
                this.paramInfo[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        reader.readBytes(this.ppid, 0, 8);
        this.totalArrayCnt = reader.readInt32();
        this.arrayBindingCnt = reader.readInt32();
        this.bindParamCnt = reader.readInt32();
        this.flag = reader.readInt32();
        int paramInfoLen = reader.readInt32();
        if (paramInfoLen > 0) {
            this.paramInfo = new TbBindparam[paramInfoLen];
            for (int i = 0; i < paramInfoLen; ++i) {
                this.paramInfo[i] = new TbBindparam();
                this.paramInfo[i].deserialize(reader);
            }
        } else {
            this.paramInfo = null;
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgBatchUpdate msg = (TbMsgBatchUpdate)obj;
        if (this.ppid == null && msg.ppid != null || this.ppid != null && msg.ppid == null) {
            return false;
        }
        if (this.ppid != null && msg.ppid != null) {
            if (this.ppid.length != msg.ppid.length) {
                return false;
            }
            for (i = 0; i < msg.ppid.length; ++i) {
                if (this.ppid[i] == msg.ppid[i]) continue;
                return false;
            }
        }
        if (this.totalArrayCnt != msg.totalArrayCnt) {
            return false;
        }
        if (this.arrayBindingCnt != msg.arrayBindingCnt) {
            return false;
        }
        if (this.bindParamCnt != msg.bindParamCnt) {
            return false;
        }
        if (this.flag != msg.flag) {
            return false;
        }
        if (this.paramInfo == null && msg.paramInfo != null || this.paramInfo != null && msg.paramInfo == null) {
            return false;
        }
        if (this.paramInfo != null && msg.paramInfo != null) {
            if (this.paramInfo.length != msg.paramInfo.length) {
                return false;
            }
            for (i = 0; i < msg.paramInfo.length; ++i) {
                if (this.paramInfo[i].equals(msg.paramInfo[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgBatchUpdate]/");
        str.append("ppid=");
        if (this.ppid != null) {
            for (i = 0; i < this.ppid.length; ++i) {
                str.append(this.ppid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("totalArrayCnt=");
        str.append(this.totalArrayCnt);
        str.append("/");
        str.append("arrayBindingCnt=");
        str.append(this.arrayBindingCnt);
        str.append("/");
        str.append("bindParamCnt=");
        str.append(this.bindParamCnt);
        str.append("/");
        str.append("flag=");
        str.append(this.flag);
        str.append("/");
        str.append("paramInfo={\n");
        if (this.paramInfo != null) {
            for (i = 0; i < this.paramInfo.length; ++i) {
                str.append("  paramInfo[" + i + "]=" + this.paramInfo[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

