/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgDplLoadStream
extends TbMsg {
    public int partialFlag;
    public byte[] streamData;
    public int streamDataLen;

    public TbMsgDplLoadStream(int autoCommit) {
        this.msgType = 57;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int partialFlag, byte[] streamData, int streamDataLen) {
        this.partialFlag = partialFlag;
        this.streamData = streamData;
        this.streamDataLen = streamDataLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.partialFlag, 4);
        if (this.streamDataLen != 0) {
            writer.writeInt(this.streamDataLen, 4);
            writer.writePadBytes(this.streamData, 0, this.streamDataLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.partialFlag = reader.readInt32();
        int streamDataLen = reader.readInt32();
        if (streamDataLen != 0) {
            this.streamData = new byte[streamDataLen];
            reader.readPadBytes(this.streamData, 0, streamDataLen);
        } else {
            reader.moveReadOffset(4);
            this.streamData = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgDplLoadStream msg = (TbMsgDplLoadStream)obj;
        if (this.partialFlag != msg.partialFlag) {
            return false;
        }
        if (this.streamData == null && msg.streamData != null || this.streamData != null && msg.streamData == null) {
            return false;
        }
        if (this.streamData != null && msg.streamData != null) {
            if (this.streamData.length != msg.streamData.length) {
                return false;
            }
            for (int i = 0; i < msg.streamData.length; ++i) {
                if (this.streamData[i] == msg.streamData[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgDplLoadStream]/");
        str.append("partialFlag=");
        str.append(this.partialFlag);
        str.append("/");
        str.append("streamData=");
        if (this.streamData != null) {
            for (int i = 0; i < this.streamData.length; ++i) {
                str.append(this.streamData[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

