/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgExecutePrefetchReply
extends TbMsg {
    public byte[] ppid = new byte[8];
    public int affectedCnt;
    public int csrId;
    public int colCnt;
    public int hiddenColCnt;
    public int colMetaArrayCnt;
    public TbColumnDesc[] colMeta;
    public int rowCnt;
    public int isFetchCompleted;
    public int rowChunkSize;

    public TbMsgExecutePrefetchReply(int autoCommit) {
        this.msgType = 11;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] ppid, int affectedCnt, int csrId, int colCnt, int hiddenColCnt, int colMetaArrayCnt, TbColumnDesc[] colMeta, int rowCnt, int isFetchCompleted, int rowChunkSize) {
        this.ppid = ppid;
        this.affectedCnt = affectedCnt;
        this.csrId = csrId;
        this.colCnt = colCnt;
        this.hiddenColCnt = hiddenColCnt;
        this.colMetaArrayCnt = colMetaArrayCnt;
        this.colMeta = colMeta;
        this.rowCnt = rowCnt;
        this.isFetchCompleted = isFetchCompleted;
        this.rowChunkSize = rowChunkSize;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeBytes(this.ppid);
        writer.writeInt(this.affectedCnt, 4);
        writer.writeInt(this.csrId, 4);
        writer.writeInt(this.colCnt, 4);
        writer.writeInt(this.hiddenColCnt, 4);
        writer.writeInt(this.colMetaArrayCnt, 4);
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMetaArrayCnt; ++i) {
                this.colMeta[i].serialize(writer);
            }
        }
        writer.writeInt(this.rowCnt, 4);
        writer.writeInt(this.isFetchCompleted, 4);
        writer.writeInt(this.rowChunkSize, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        reader.readBytes(this.ppid, 0, 8);
        this.affectedCnt = reader.readInt32();
        this.csrId = reader.readInt32();
        this.colCnt = reader.readInt32();
        this.hiddenColCnt = reader.readInt32();
        int colMetaLen = reader.readInt32();
        if (colMetaLen > 0) {
            this.colMeta = new TbColumnDesc[colMetaLen];
            for (int i = 0; i < colMetaLen; ++i) {
                this.colMeta[i] = new TbColumnDesc();
                this.colMeta[i].deserialize(reader);
            }
        } else {
            this.colMeta = null;
        }
        this.rowCnt = reader.readInt32();
        this.isFetchCompleted = reader.readInt32();
        this.rowChunkSize = reader.readInt32();
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgExecutePrefetchReply msg = (TbMsgExecutePrefetchReply)obj;
        if (this.ppid == null && msg.ppid != null || this.ppid != null && msg.ppid == null) {
            return false;
        }
        if (this.ppid != null && msg.ppid != null) {
            if (this.ppid.length != msg.ppid.length) {
                return false;
            }
            for (i = 0; i < msg.ppid.length; ++i) {
                if (this.ppid[i] == msg.ppid[i]) continue;
                return false;
            }
        }
        if (this.affectedCnt != msg.affectedCnt) {
            return false;
        }
        if (this.csrId != msg.csrId) {
            return false;
        }
        if (this.colCnt != msg.colCnt) {
            return false;
        }
        if (this.hiddenColCnt != msg.hiddenColCnt) {
            return false;
        }
        if (this.colMeta == null && msg.colMeta != null || this.colMeta != null && msg.colMeta == null) {
            return false;
        }
        if (this.colMeta != null && msg.colMeta != null) {
            if (this.colMeta.length != msg.colMeta.length) {
                return false;
            }
            for (i = 0; i < msg.colMeta.length; ++i) {
                if (this.colMeta[i].equals(msg.colMeta[i])) continue;
                return false;
            }
        }
        if (this.rowCnt != msg.rowCnt) {
            return false;
        }
        if (this.isFetchCompleted != msg.isFetchCompleted) {
            return false;
        }
        return this.rowChunkSize == msg.rowChunkSize;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgExecutePrefetchReply]/");
        str.append("ppid=");
        if (this.ppid != null) {
            for (i = 0; i < this.ppid.length; ++i) {
                str.append(this.ppid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("affectedCnt=");
        str.append(this.affectedCnt);
        str.append("/");
        str.append("csrId=");
        str.append(this.csrId);
        str.append("/");
        str.append("colCnt=");
        str.append(this.colCnt);
        str.append("/");
        str.append("hiddenColCnt=");
        str.append(this.hiddenColCnt);
        str.append("/");
        str.append("colMeta={\n");
        if (this.colMeta != null) {
            for (i = 0; i < this.colMeta.length; ++i) {
                str.append("  colMeta[" + i + "]=" + this.colMeta[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        str.append("rowCnt=");
        str.append(this.rowCnt);
        str.append("/");
        str.append("isFetchCompleted=");
        str.append(this.isFetchCompleted);
        str.append("/");
        str.append("rowChunkSize=");
        str.append(this.rowChunkSize);
        str.append("/");
        return str.append("\n").toString();
    }
}

