/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgSvrLogCheck
extends TbMsg {
    public int rbaSeqno;
    public int rbaBlkno;
    public byte[] log;
    public int logLen;

    public TbMsgSvrLogCheck(int autoCommit) {
        this.msgType = 110;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int rbaSeqno, int rbaBlkno, byte[] log, int logLen) {
        this.rbaSeqno = rbaSeqno;
        this.rbaBlkno = rbaBlkno;
        this.log = log;
        this.logLen = logLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.rbaSeqno, 4);
        writer.writeInt(this.rbaBlkno, 4);
        if (this.logLen != 0) {
            writer.writeInt(this.logLen, 4);
            writer.writePadBytes(this.log, 0, this.logLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.rbaSeqno = reader.readInt32();
        this.rbaBlkno = reader.readInt32();
        int logLen = reader.readInt32();
        if (logLen != 0) {
            this.log = new byte[logLen];
            reader.readPadBytes(this.log, 0, logLen);
        } else {
            reader.moveReadOffset(4);
            this.log = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgSvrLogCheck msg = (TbMsgSvrLogCheck)obj;
        if (this.rbaSeqno != msg.rbaSeqno) {
            return false;
        }
        if (this.rbaBlkno != msg.rbaBlkno) {
            return false;
        }
        if (this.log == null && msg.log != null || this.log != null && msg.log == null) {
            return false;
        }
        if (this.log != null && msg.log != null) {
            if (this.log.length != msg.log.length) {
                return false;
            }
            for (int i = 0; i < msg.log.length; ++i) {
                if (this.log[i] == msg.log[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgSvrLogCheck]/");
        str.append("rbaSeqno=");
        str.append(this.rbaSeqno);
        str.append("/");
        str.append("rbaBlkno=");
        str.append(this.rbaBlkno);
        str.append("/");
        str.append("log=");
        if (this.log != null) {
            for (int i = 0; i < this.log.length; ++i) {
                str.append(this.log[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

