/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg.common;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public abstract class TbMsgError
extends TbMsg {
    public boolean haveError = true;
    private TbSQLException prevException;
    private TbSQLException rootException;

    protected void readErrorStackInfo(TbStreamDataReader reader) throws SQLException {
        int errorStackLen = reader.readInt32();
        if (errorStackLen == 0) {
            this.haveError = false;
            reader.moveReadOffset(4);
            return;
        }
        reader.moveReadOffset(4);
        reader.moveReadOffset(4);
        int errCnt = reader.readInt32();
        if (errCnt <= 0) {
            this.haveError = false;
            return;
        }
        reader.moveReadOffset(4);
        for (int i = 0; i < errCnt; ++i) {
            reader.moveReadOffset(8);
            reader.moveReadOffset(4);
            int errCode = reader.readInt32();
            reader.moveReadOffset(4);
            reader.moveReadOffset(4);
            reader.moveReadOffset(1);
            byte[] sqlState = new byte[6];
            reader.readBytes(sqlState, 0, 6);
            int sqlStateLen = 6;
            for (int j = 0; j < 6; ++j) {
                if (sqlState[j] != 0) continue;
                sqlStateLen = j;
                break;
            }
            byte[] desc = new byte[712];
            reader.readBytes(desc, 0, 712);
            int descLen = 712;
            for (int j = 0; j < 712; ++j) {
                if (desc[j] != 0) continue;
                descLen = j;
                break;
            }
            reader.moveReadOffset(4);
            int dmlLine = reader.readInt32();
            int dmlCol = reader.readInt32();
            reader.readInt32();
            reader.readInt32();
            reader.readInt32();
            reader.readInt32();
            TbSQLException exception = new TbSQLException(errCode, new String(sqlState, 0, sqlStateLen), new String(desc, 0, descLen));
            exception.setDmlErrorLine(dmlLine);
            exception.setDmlErrorCol(dmlCol);
            if (this.prevException == null) {
                this.rootException = exception;
            } else {
                this.prevException.setNextException(exception);
            }
            this.prevException = exception;
        }
    }

    public TbSQLException getException(int code) {
        if (!this.haveError) {
            return new TbSQLException(code);
        }
        return this.rootException;
    }
}

