/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABResultSet;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.ex;
import Altibase.jdbc.driver.version;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ABDatabaseMetaData
implements DatabaseMetaData {
    static final int MAX_COMPOSITE_IDX_NUM = 32;
    static final int QCM_NOTNULL = 0;
    static final int QCM_UNIQUE = 1;
    static final int QCM_PRIMARY_KEY = 2;
    static final int QCM_FOREIGN_KEY = 3;
    static final int QCM_CHECK = 4;
    private ABConnection cn;
    private Statement st;
    StringBuffer sql;

    ABDatabaseMetaData(ABConnection conn) throws SQLException {
        this.cn = conn;
        this.st = conn.createStatement(1004, 1007);
        this.sql = new StringBuffer(1024);
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.sql.setLength(0);
        this.sql.append("SELECT ''  TYPE_CAT,'' TYPE_SCHEM, '' TYPE_NAME,'' ATTR_NAME,0 DATA_TYPE, ''  ATTR_TYPE_NAME,0 ATTR_SIZE,0 DECIMAL_DIGITS,0 NUM_PREC_RADIX,");
        this.sql.append("NULL NULLABLE,'' REMARKS,'' ATTR_DEF,NULL SQL_DATA_TYPE, NULL SQL_DATETIME_SUB,NULL CHAR_OCTET_LENGTH,NULL ORDINAL_POSITION,'YES' IS_NULLABLE,");
        this.sql.append("'' SCOPE_CATALOG,'' SCOPE_SCHEMA,'' SCOPE_TABLE,'' SOURCE_DATA_TYPE from DUAL WHERE 1=0");
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public synchronized ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.sql.setLength(0);
        this.sql.append("SELECT 2 as SCOPE,c.column_name as COLUMN_NAME,t.sql_data_type as DATA_TYPE,t.type_name as TYPE_NAME,decode(c.precision,0,t.COLUMN_SIZE,c.precision) as COLUMN_SIZE,c.precision as BUFFER_LENGTH,c.scale as DECIMAL_DIGITS,1 as PSEUDO_COLUMN FROM system_.SYS_CONSTRAINT_COLUMNS_ a,system_.SYS_CONSTRAINTS_ b,system_.SYS_COLUMNS_ c,system_.SYS_TABLES_ d,system_.SYS_USERS_ e,X$DATATYPE t WHERE a.CONSTRAINT_ID=b.CONSTRAINT_ID and b.constraint_type=3 and a.COLUMN_ID=c.COLUMN_ID and b.table_id=d.table_id and d.user_id=e.user_id");
        if (schema != null && schema.length() > 0) {
            this.sql.append(" and e.user_name='");
            this.sql.append(schema);
            this.sql.append('\'');
        }
        if (table != null && table.length() > 0) {
            this.sql.append(" and d.table_name='");
            this.sql.append(table);
            this.sql.append('\'');
        }
        if (!nullable) {
            this.sql.append(" and C.IS_NULLABLE='T'");
        }
        this.sql.append(" and 0 <= ");
        this.sql.append(scope);
        this.sql.append(" and c.data_type=t.data_type ORDER BY 4");
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public synchronized ResultSet getCatalogs() throws SQLException {
        ResultSet rs = this.st.executeQuery("select '' as TABLE_CAT from dual order by 1");
        return rs;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public synchronized ResultSet getColumnPrivileges(String catalog, String schema, String table, String column) throws SQLException {
        ex.exception((short)30);
        return null;
    }

    public synchronized ResultSet getColumns(String catalog, String schema, String table, String column) throws SQLException {
        this.sql.setLength(0);
        this.sql.append("SELECT '' as TABLE_CAT,c.user_name as TABLE_SCHEM,b.table_name as TABLE_NAME,a.column_name as COLUMN_NAME,nvl2(f.column_id,3010,a.data_type) as DATA_TYPE,nvl2(f.column_id,'TIMESTAMP',t.type_name) as TYPE_NAME,decode(a.precision,0,t.column_size,a.precision) as COLUMN_SIZE, decode(a.size, 4294967295, 2147483647, a.size ) as BUFFER_LENGTH,a.scale as  DECIMAL_DIGITS,");
        this.sql.append("t.NUM_PREC_RADIX as NUM_PREC_RADIX,decode(a.IS_NULLABLE,'F',0,1) as NULLABLE, a.STORE_TYPE as REMARKS,a.DEFAULT_VAL as COLUMN_DEF,t.SQL_DATA_TYPE as SQL_DATA_TYPE,t.SQL_DATETIME_SUB as SQL_DATETIME_SUB,");
        this.sql.append("decode(a.size, 4294967295, 2147483647, a.size ) as CHAR_OCTET_LENGTH,a.column_order as ORDINAL_POSITION,decode(a.IS_NULLABLE,'F','NO','YES') as IS_NULLABLE,");
        this.sql.append("'' as SCOPE_CATALOG,'' as SCOPE_SCHEMA,'' as SCOPE_TABLE,null as  SOURCE_DATA_TYPE ");
        this.sql.append("FROM system_.sys_tables_  b,system_.sys_users_ c,X$DATATYPE t,system_.sys_columns_ a ");
        this.sql.append("LEFT OUTER JOIN (select d.table_id table_id,d.column_id column_id from system_.SYS_CONSTRAINT_COLUMNS_ d,system_.SYS_CONSTRAINTS_ e,system_.sys_tables_ f where d.constraint_id=e.constraint_id and e.constraint_type=5 and e.table_id=f.table_id ");
        if (table != null) {
            this.sql.append("and f.table_name LIKE '");
            this.sql.append(table);
            this.sql.append("' escape '\\'");
        }
        this.sql.append(") f on f.column_id=a.column_id WHERE b.TABLE_TYPE in('T','V','Q') and a.table_id=b.table_id and a.data_type=t.data_type  and b.user_id=c.user_id ");
        if (schema != null) {
            this.sql.append("and c.user_name LIKE '");
            this.sql.append(schema);
            this.sql.append("' escape '\\'  ");
        }
        if (table != null) {
            this.sql.append("and b.table_name LIKE '");
            this.sql.append(table);
            this.sql.append("' escape '\\'");
        }
        if (column != null) {
            this.sql.append("and a.column_name LIKE '");
            this.sql.append(column);
            this.sql.append("' escape '\\'");
        }
        this.sql.append("order by a.column_order");
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public Connection getConnection() throws SQLException {
        return this.cn;
    }

    public synchronized ResultSet getCrossReference(String pcat, String pschema, String ptable, String fcat, String fschema, String ftable) throws SQLException {
        return this.keys_query(pcat, pschema, ptable, fcat, fschema, ftable);
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(version.pkgVersion.substring(0, 1));
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return Integer.parseInt(version.pkgVersion.substring(2, 3));
    }

    public String getDatabaseProductName() throws SQLException {
        return "Altibase";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return version.pkgVersion;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 4;
    }

    public int getDriverMajorVersion() {
        return 5;
    }

    public int getDriverMinorVersion() {
        return 4;
    }

    public String getDriverName() throws SQLException {
        return version.version;
    }

    public String getDriverVersion() throws SQLException {
        return "5.4.4";
    }

    public synchronized ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.keys_query(catalog, schema, table, null, null, null);
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "";
    }

    public synchronized ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.keys_query(null, null, null, catalog, schema, table);
    }

    public synchronized ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String uniStr;
        ex.test(table == null || table.compareTo("") == 0, (short)97, SQLStates.mFixmsg[14]);
        String userStr = schema != null && schema != "" ? " and e.user_name='" + schema.toUpperCase() + "'" : "";
        uniStr = unique ? (uniStr = " and a.is_unique = 'T'") : "";
        String sql = " select '' as TABLE_CAT,E.user_name as TABLE_SCHEM,D.table_name as TABLE_NAME,decode(a.is_unique,'T',0,'F',1,1) as NON_UNIQUE,'' as INDEX_QUALIFIER,a.index_name as INDEX_NAME,a.index_type as TYPE,b.index_col_order+1 as ORDINAL_POSITION,C.column_name as COLUMN_NAME, B.SORT_ORDER as ASC_OR_DESC,0 as CARDINALITY,0 as PAGES,'' as FILTER_CONDITION FROM system_.sys_indices_ A,system_.sys_index_columns_ B,system_.sys_columns_ C,system_.sys_tables_ D,system_.sys_users_ E WHERE a.table_id=b.table_id  and c.column_id = b.column_id and b.index_id  = a.index_id and a.table_id  = d.table_id and d.user_id   = e.user_id " + userStr + " and D.table_name='" + table.toUpperCase() + "'" + uniStr + " order by 6,8";
        ResultSet rs = this.st.executeQuery(sql);
        return rs;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 5;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 4;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 32000;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 45;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 32000;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 40;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 1024;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 1024;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 1024;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1024;
    }

    public int getMaxConnections() throws SQLException {
        int max = 0;
        ResultSet rs = this.st.executeQuery("select VALUE1 from V$PROPERTY where name = 'MAX_CLIENT'");
        if (rs.next()) {
            max = rs.getInt(1);
        }
        rs.close();
        return max;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 45;
    }

    public int getMaxIndexLength() throws SQLException {
        return 32;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 40;
    }

    public int getMaxRowSize() throws SQLException {
        return 32000;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 40;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 40;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 32;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 40;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ADD2,ASIN,ATAN,ATAN2,AVG,COS,COSH,DIV2,EXP,FLOOR,GREATEST,LN,LOG,LOWER,MAX,MIN,MINUS,MOD,MUL2,NVL,NVL2,POWER,RANDOM,ROUND,SIGN,SIN,SINH,SQRT,SUM,TAN,TANH,VARIANCE";
    }

    public synchronized ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (catalog == null) {
            catalog = this.cn.getProperty("databaseName", "").toUpperCase();
        }
        ex.test(table == null || table.compareTo("") == 0, (short)97, SQLStates.mFixmsg[14]);
        String userStr = "";
        if (schema != null && schema.compareTo("") != 0) {
            userStr = " and e.user_name like '" + schema.toUpperCase() + "'  escape '\\' ";
        }
        String sql = "select '" + catalog + "' as TABLE_CAT" + ", e.user_name  as TABLE_SCHEM" + ",d.table_name  as TABLE_NAME" + ",c.column_name as COLUMN_NAME" + ",a.CONSTRAINT_COL_ORDER+1 as KEY_SEQ" + ",b.CONSTRAINT_NAME        as PK_NAME" + ",b.index_id,b.column_cnt" + " from system_.SYS_CONSTRAINT_COLUMNS_ a, system_.SYS_CONSTRAINTS_ b," + "system_.SYS_COLUMNS_ c,system_.SYS_TABLES_ d,system_.SYS_USERS_ e " + " where a.CONSTRAINT_ID = b.CONSTRAINT_ID and b.constraint_type = 3" + " and a.COLUMN_ID = c.COLUMN_ID" + " and b.table_id  = d.table_id" + " and d.user_id = e.user_id" + userStr + " and d.table_name like '" + table.toUpperCase() + "'  escape '\\' " + "order by 2,3,5";
        ABResultSet rs = (ABResultSet)this.st.executeQuery(sql);
        return rs;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.sql.setLength(0);
        schemaPattern = schemaPattern != null && schemaPattern.compareTo("") != 0 && schemaPattern.compareTo("%") != 0 ? " AND d.user_name  LIKE '" + schemaPattern.toUpperCase() + "'  escape '\\'" : "";
        procedureNamePattern = procedureNamePattern != null && procedureNamePattern.compareTo("") != 0 && procedureNamePattern.compareTo("%") != 0 ? " AND  b.proc_name LIKE '" + procedureNamePattern.toUpperCase() + "' escape '\\'" : "";
        columnNamePattern = columnNamePattern != null && columnNamePattern.compareTo("") != 0 ? " AND a.para_name LIKE '" + columnNamePattern.toUpperCase() + "' escape '\\'" : "";
        this.sql.append("SELECT '' as PROCEDURE_CAT,d.user_name as PROCEDURE_SCHEM,b.PROC_NAME as PROCEDURE_NAME,'RETURN_VALUE' as COLUMN_NAME,5 as COLUMN_TYPE,b.RETURN_DATA_TYPE as DATA_TYPE,t.type_name as  TYPE_NAME,decode(b.RETURN_PRECISION,0,t.column_size,b.RETURN_PRECISION) as PRECISION,decode(b.RETURN_SIZE,0,b.RETURN_PRECISION,b.RETURN_SIZE) as LENGTH,b.RETURN_SCALE as SCALE,t.NUM_PREC_RADIX as RADIX,2 as NULLABLE,'RETURN VALUE' as REMARKS,'' as COLUMN_DEF,t.SQL_DATA_TYPE as SQL_DATA_TYPE,t.SQL_DATETIME_SUB as SQL_DATETIME_SUB,decode(b.RETURN_SIZE,0,b.RETURN_PRECISION, b.RETURN_SIZE) as CHAR_OCTET_LENGTH,0 as ORDINAL_POSITION,1 as IS_NULLABLE FROM X$DATATYPE t,system_.sys_procedures_ b,system_.sys_users_ d WHERE b.OBJECT_TYPE = 1 AND b.user_id=d.user_id AND t.data_type=b.RETURN_DATA_TYPE ");
        this.sql.append(schemaPattern);
        this.sql.append(procedureNamePattern);
        this.sql.append(" UNION SELECT '' as PROCEDURE_CAT,d.user_name as PROCEDURE_SCHEM,b.proc_name as PROCEDURE_NAME,a.para_name as COLUMN_NAME,decode(a.inout_type,0,1,2,2,1,4,0) as COLUMN_TYPE,a.data_type as DATA_TYPE,t.type_name as  TYPE_NAME,decode(a.precision,0,t.COLUMN_SIZE,a.precision) as PRECISION,decode(a.size,0,a.precision,a.size) as LENGTH,a.scale as SCALE,t.NUM_PREC_RADIX as RADIX,2 as NULLABLE,'' as REMARKS,a.default_val as COLUMN_DEF,t.SQL_DATA_TYPE as SQL_DATA_TYPE,t.SQL_DATETIME_SUB as SQL_DATETIME_SUB,decode(a.size,0,a.precision, a.size) as CHAR_OCTET_LENGTH,a.para_order as ORDINAL_POSITION,'' as IS_NULLABLE FROM X$DATATYPE t,system_.sys_proc_paras_ a,system_.sys_procedures_ b,system_.sys_users_ d WHERE a.proc_oid=b.proc_oid AND b.user_id=d.user_id AND t.data_type=a.data_type");
        this.sql.append(schemaPattern);
        this.sql.append(procedureNamePattern);
        this.sql.append(columnNamePattern);
        this.sql.append(" ORDER BY 2,3,18");
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.sql.setLength(0);
        this.sql.append("select '' as PROCEDURE_CAT,d.user_name as PROCEDURE_SCHEM, a.proc_name as PROCEDURE_NAME,");
        this.sql.append("(select count(*) from system_.sys_proc_paras_ p where ( p.INOUT_TYPE = 0 or p.INOUT_TYPE = 2) AND p.proc_oid = a.proc_oid ) as NUM_INPUT_PARAMS,");
        this.sql.append("(select count(*)  from system_.sys_proc_paras_ p where ( p.INOUT_TYPE = 1 or p.INOUT_TYPE = 2) AND p.proc_oid = a.proc_oid ) as NUM_OUTPUT_PARAMS,");
        this.sql.append("0  as NUM_RESULT_SETS,");
        this.sql.append("'' as REMARKS,decode(a.object_type,0,1,1,2,0) as PROCEDURE_TYPE from system_.sys_procedures_ a,system_.sys_users_ d where a.user_id=d.user_id ");
        if (schemaPattern != null) {
            this.sql.append(" AND d.user_name  LIKE '");
            this.sql.append(schemaPattern.toUpperCase());
            this.sql.append("' escape '\\'");
        }
        if (procedureNamePattern != null) {
            this.sql.append(" AND  a.proc_name LIKE '");
            this.sql.append(procedureNamePattern.toUpperCase());
            this.sql.append("' escape '\\'");
        }
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public String getProcedureTerm() throws SQLException {
        return "stored procedure";
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public synchronized ResultSet getSchemas() throws SQLException {
        String sql = "select user_name as TABLE_SCHEM,'" + this.cn.getProperty("databaseName", "").toUpperCase() + "' as TABLE_CATALOG " + " from system_.sys_users_ order by 1";
        ABResultSet rs = (ABResultSet)this.st.executeQuery(sql);
        return rs;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "ADD,ALTER,COLUMN,DATE,DROP,FOREGIN,RENAME,IDENTIFIED,INDEX,NUMBER,REPLECATION,BROWSE,BULK,CHECKPOINT,DATABASE,DISK,DUMMY,DUMP,IF,INDEX,LOAD,OFF,PLAN,PRINT,READ,RETURN,ROWCOUNT,RULE,SAVE,STATISTICS,TRIGGER,TRUNCATE";
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,CASE2,CHOSUNG,CHR,DESDECRYPT,DESENCRYPT,DIGEST,DIGITS,DUMP,INSTR,INSTRB,LENGTH,LPAD,LTRIM,NOTLIKE,REPLACE2,REPLICATE,REVERSE_STR,RPAD,RTRIM,SUB2,SUBSTR,SUBSTRB,TO_CHAR,TO_HEX,TRANSLATE,TRIM,TRUNC,UPPER,CHAR_LENGTH,CHARACTER_LENGTH,LOWER,OCTET_LENGTH,TO_CHAR,TO_NUMBER,TO_DATE,LTRIM,RTRIM,POSITION";
    }

    public synchronized ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.st.executeQuery("SELECT '' TABLE_CAT,'' TABLE_SCHEM,'' TABLE_NAME,'' SUPERTABLE_NAME from dual WHERE 0!=0");
    }

    public synchronized ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.st.executeQuery("SELECT '' TYPE_CAT,'' TYPE_SCHEM,'' TYPE_NAME,'' SUPERTYPE_CAT,'' SUPERTYPE_SCHEM,'' SUPERTYPE_NAME from dual WHERE 0!=0");
    }

    public String getSystemFunctions() throws SQLException {
        return "DUMP,NVL,DECODE";
    }

    public synchronized ResultSet getTablePrivileges(String catalog, String schema, String table) throws SQLException {
        this.sql.setLength(0);
        this.sql.append("select '' as TABLE_CAT,u_t.user_name TABLE_SCHEM,u_t.table_name TABLE_NAME,u.user_name GRANTOR,u2.user_name GRANTEE,priv.priv_name PRIVILEGE,decode(obj.with_grant_option,1,'YES',0,'NO') IS_GRANTABLE ");
        this.sql.append("from (select t.table_id table_id, t.table_name table_name, u.user_name user_name from system_.sys_users_ u, system_.sys_tables_ t where u.user_id = t.user_id and t.table_type='T'");
        if (schema != null) {
            this.sql.append(" and u.user_name LIKE '");
            this.sql.append(schema.toUpperCase());
            this.sql.append("' escape '\\'");
        }
        if (table != null) {
            this.sql.append("  and t.table_name LIKE '");
            this.sql.append(table.toUpperCase());
            this.sql.append("' escape '\\'");
        }
        this.sql.append(") U_T,system_.sys_users_ u,system_.sys_users_ u2,system_.sys_privileges_ priv,system_.sys_grant_object_ obj where obj.obj_id = u_t.table_id and u.user_id = obj.grantor_id and u2.user_id = obj.grantee_id and priv.priv_id = obj.priv_id order by 2,3,6,5");
        ResultSet rs = this.st.executeQuery(this.sql.toString());
        return rs;
    }

    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String user_filter_sql = "";
        String table_filter_sql = "";
        if (schemaPattern != null && schemaPattern.compareTo("") != 0) {
            user_filter_sql = " and a.user_name like '" + schemaPattern.toUpperCase() + "'";
        }
        if (tableNamePattern != null && tableNamePattern.compareTo("") != 0) {
            table_filter_sql = " and b.table_name like '" + tableNamePattern.toUpperCase() + "'";
        }
        String _sql = "select '" + (catalog == null ? "" : catalog) + "' as TABLE_CAT" + ",a.user_name  as TABLE_SCHEM" + ",b.table_name as TABLE_NAME" + ",decode(a.user_name,'SYSTEM_','SYSTEM ','') " + "|| decode(b.table_type,'T','TABLE','V','VIEW','S','SEQUENCE') as TABLE_TYPE" + ",''           as REMARKS" + ",''           as TYPE_CAT" + ",''           as TYPE_SCHEM" + ",''           as TYPE_NAME" + ",''           as SELF_REFERENCING_COL_NAME" + ",decode(a.user_id,1,'SYSTEM','USER')     as REF_GENERATION" + ",b.column_count " + " from system_.sys_users_ a,system_.sys_tables_ b " + " where a.user_id=b.user_id ";
        String sql = "";
        if (types != null && types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                String add_sql = "";
                if (types[i].equalsIgnoreCase("TABLE")) {
                    add_sql = add_sql + _sql + user_filter_sql + table_filter_sql + " and b.table_type='T' and a.user_name<>'SYSTEM_'";
                } else if (types[i].equalsIgnoreCase("SEQUENCE")) {
                    add_sql = add_sql + _sql + user_filter_sql + table_filter_sql + " and b.table_type='S'";
                } else if (types[i].equalsIgnoreCase("VIEW")) {
                    add_sql = add_sql + _sql + user_filter_sql + table_filter_sql + " and b.table_type='V'";
                } else if (types[i].equalsIgnoreCase("SYSTEM TABLE")) {
                    add_sql = add_sql + _sql + user_filter_sql + table_filter_sql + " and b.table_type='T' and a.user_name='SYSTEM_'";
                }
                if (add_sql == "") continue;
                sql = sql + (sql == "" ? "" : " UNION ALL ") + add_sql;
            }
        } else {
            sql = sql + _sql + user_filter_sql + table_filter_sql;
        }
        sql = sql + " order by 4,2,3";
        ResultSet rs = this.st.executeQuery(sql);
        return rs;
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = " select  'QUEUE' as TABLE_TYPE from dual UNION select  'TABLE' from dual UNION select  'VIEW'  from dual";
        ResultSet rs = this.st.executeQuery(sql);
        return rs;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "SYSDATE, TRUNC, EXTRACT, LAST_DAY, ADD_MONTHS, NEXT_DAY";
    }

    public synchronized ResultSet getTypeInfo() throws SQLException {
        ResultSet rs = this.st.executeQuery("select TYPE_NAME, DATA_TYPE,FIXED_PREC_SCALE as PRECISION,LITERAL_PREFIX,LITERAL_SUFFIX,CREATE_PARAM as CREATE_PARAMS,NULLABLE,CASE_SENSITIVE,SEARCHABLE,UNSIGNED_ATTRIBUTE,FIXED_PREC_SCALE,'F' as AUTO_INCREMENT,LOCAL_TYPE_NAME,MINIMUM_SCALE,MAXIMUM_SCALE,SQL_DATA_TYPE,SQL_DATETIME_SUB,NUM_PREC_RADIX from V$DATATYPE order by 2");
        return rs;
    }

    public ResultSet getUDTs(String catalog, String schema, String table, int[] types) throws SQLException {
        ex.exception((short)30);
        return null;
    }

    public String getURL() throws SQLException {
        return this.cn.getURL();
    }

    public String getUserName() throws SQLException {
        return this.cn.getProperty("user", "");
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ABResultSet rs = (ABResultSet)this.getBestRowIdentifier(catalog, schema, table, 0, true);
        return rs;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concur) throws SQLException {
        boolean ret = false;
        switch (type) {
            case 1003: 
            case 1004: {
                ret = concur == 1007;
            }
        }
        return ret;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return 1 == holdability;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        boolean ret = false;
        switch (level) {
            case 2: 
            case 4: 
            case 8: {
                ret = true;
            }
        }
        return ret;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    protected void finalize() throws Throwable {
        if (this.st != null) {
            this.st.close();
            this.st = null;
            this.cn = null;
        }
        super.finalize();
    }

    protected ResultSet keys_query(String pcat, String pschema, String ptable, String fcat, String fschema, String ftable) throws SQLException {
        ResultSet rs = this.st.executeQuery("SELECT P.PKTABLE_CAT as PKTABLE_CAT,P.PKTABLE_SCHEM as PKTABLE_SCHEM,P.PKTABLE_NAME as PKTABLE_NAME,P.PK_COLUMN_NAME as PKCOLUMN_NAME,F.FKTABLE_CAT as FKTABLE_CAT,F.FKTABLE_SCHEM as FKTABLE_SCHEM, F.FKTABLE_NAME as FKTABLE_NAME,F.FK_COLUMN_NAME as FKCOLUMN_NAME,F.KEY_SEQ as KEY_SEQ,3 as UPDATE_RULE,3 as DELETE_RULE,F.FK_NAME as FK_NAME,P.PK_NAME as PK_NAME,7 as DEFERRABILITY  FROM(  SELECT '" + (pcat == null ? "" : pcat) + "' as PKTABLE_CAT," + " pe.user_name             as  PKTABLE_SCHEM," + " pd.table_name            as  PKTABLE_NAME," + " pc.column_name           as  PK_COLUMN_NAME," + " pa.constraint_name       as  PK_NAME," + " pb.constraint_col_order+1  as  KEY_SEQ," + " pd.table_id                as  CID," + " pa.INDEX_ID                as  idxid " + "FROM " + "system_.sys_constraints_         pa," + "system_.sys_constraint_columns_  pb," + "system_.sys_columns_             pc," + "system_.sys_tables_              pd," + "system_.sys_users_               pe " + "WHERE ((( pe.user_name  like " + (pschema == null ? "'%'" : "'" + pschema + "'") + " escape '\\' and pe.user_id = pd.user_id ) " + " and pd.table_name like " + (ptable == null ? "'%'" : "'" + ptable + "'") + " escape '\\' and pe.user_id = pa.user_id and pa.table_id = pd.table_id ) " + " and pa.constraint_id=pb.constraint_id " + " and pa.constraint_type=" + 3 + " and pb.column_id=pc.column_id )" + ") AS P " + " INNER JOIN " + " ( select '" + (fcat == null ? "" : fcat) + "' as  FKTABLE_CAT,fe.user_name as FKTABLE_SCHEM, fd.table_name            as  FKTABLE_NAME," + " fc.column_name           as  FK_COLUMN_NAME," + " fa.constraint_name       as  FK_NAME," + " fb.constraint_col_order+1  as  KEY_SEQ," + " fa.referenced_table_id     as  CID," + " fa.REFERENCED_INDEX_ID     as  idxid" + " FROM " + " system_.sys_constraints_         fa," + " system_.sys_constraint_columns_  fb," + " system_.sys_columns_             fc," + " system_.sys_tables_              fd," + " system_.sys_users_               fe " + "WHERE ((( fe.user_name  like " + (fschema == null ? "'%'" : "'" + fschema + "'") + " escape '\\' and  fe.user_id = fd.user_id )" + " and  fd.table_name like " + (ftable == null ? "'%'" : "'" + ftable + "'") + " escape '\\' and  fe.user_id = fa.user_id and fa.table_id = fd.table_id )" + "   and  fa.constraint_id=fb.constraint_id" + " and fb.column_id=fc.column_id)" + ") AS F " + " ON (P.CID=F.CID and P.IDXID=F.IDXID and P.KEY_SEQ=F.KEY_SEQ)" + " ORDER BY  FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
        return rs;
    }
}

