/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABRConnection;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.SQLStates;
import java.sql.SQLException;
import java.sql.Statement;

public class ABRStatement
extends ABStatement {
    static final long serialVersionUID = 22L;
    protected Statement sstmt;

    protected ABRStatement(ABRConnection c) throws SQLException {
        super(c);
        this.sstmt = c.s_con.createStatement();
    }

    protected ABRStatement(ABRConnection c, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(c, resultSetType, resultSetConcurrency);
        this.sstmt = c.s_con.createStatement(resultSetType, resultSetConcurrency);
    }

    public void addBatch(String sql) throws SQLException {
        super.addBatch(sql);
        this.sstmt.addBatch(sql);
    }

    public void cancel() throws SQLException {
        super.cancel();
        this.sstmt.cancel();
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.sstmt.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        super.clearWarnings();
        this.sstmt.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.sstmt.close();
    }

    public boolean execute(String sql) throws SQLException {
        boolean ret = false;
        if (super.execute(sql)) {
            ret = true;
        } else {
            this.sstmt.execute(sql);
        }
        if (!ret && ((ABRConnection)this.mConnection).autocommit) {
            ((ABRConnection)this.mConnection).s_con.commit();
            this.mConnection.commit();
        }
        return ret;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        switch (autoGeneratedKeys) {
            case 1: {
                this.wn.warning((short)10, SQLStates.mWarmsg[2]);
            }
        }
        return this.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        int[] ret = super.executeBatch();
        int[] slv = this.sstmt.executeBatch();
        return ret;
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        int ret;
        try {
            ret = super.executeUpdate(sql);
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            throw e;
        }
        try {
            ret = this.sstmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            if (((ABRConnection)this.mConnection).autocommit) {
                this.mConnection.rollback();
            }
            System.err.println(e.getMessage());
            throw e;
        }
        if (((ABRConnection)this.mConnection).autocommit) {
            ((ABRConnection)this.mConnection).s_con.commit();
            this.mConnection.commit();
        }
        return ret;
    }

    public void setFetchSize(int rows) throws SQLException {
        super.setFetchSize(rows);
        this.sstmt.setFetchSize(rows);
    }
}

