/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;

public class ResultSetLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(ResultSet.class);
    boolean first = true;
    private ResultSet rs;

    private ResultSetLogProxy(ResultSet rs) {
        this.rs = rs;
        if (log.isDebugEnabled()) {
            log.debug("{rset-" + this.id + "} ResultSet");
        }
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            Object o = method.invoke((Object)this.rs, params);
            if (GET_METHODS.contains(method.getName())) {
                if (params[0] instanceof String) {
                    if (this.rs.wasNull()) {
                        this.setColumn(params[0], null);
                    } else {
                        this.setColumn(params[0], o);
                    }
                }
            } else if ("next".equals(method.getName()) || "close".equals(method.getName())) {
                String s = this.getValueString();
                if (!"[]".equals(s)) {
                    if (this.first) {
                        this.first = false;
                        if (log.isDebugEnabled()) {
                            log.debug("{rset-" + this.id + "} Header: " + this.getColumnString());
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("{rset-" + this.id + "} Result: " + s);
                    }
                }
                this.clearColumnInfo();
            }
            return o;
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static ResultSet newInstance(ResultSet rs) {
        ResultSetLogProxy handler = new ResultSetLogProxy(rs);
        ClassLoader cl = ResultSet.class.getClassLoader();
        return (ResultSet)Proxy.newProxyInstance(cl, new Class[]{ResultSet.class}, (InvocationHandler)handler);
    }

    public ResultSet getRs() {
        return this.rs;
    }
}

