/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABConnection;
import Altibase.jdbc.driver.ABResultSetMetaData;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.BindMeta;
import Altibase.jdbc.driver.Blob;
import Altibase.jdbc.driver.Clob;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.ex;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class ABResultSet
extends ArrayList
implements ResultSet,
SQLStates {
    static final long serialVersionUID = 1L;
    static final int RESULT_SET_INIT_STATE = 0;
    static final int RESULT_SET_BEGIN_STATE = 1;
    static final int RESULT_SET_END_STATE = 2;
    static final int RESULT_SET_CLOSED_STATE = 3;
    private ABConnection mConnection;
    private ABResultSetMetaData mMetaData;
    private short mResultSetID;
    private int mFetchSize;
    private int mMaxRows;
    private boolean mLastFetched;
    private int mCurrentCursorPosition;
    private int mCurrentFetchPosition;
    private int mBufferIndex;
    private int mMoveDirection;
    private ABStatement mStatement;
    private int mResultSetType;
    private int mState;
    private int mFetchedRowNum;
    private short mFetchedColNum;
    private ex wn = new ex();

    ABResultSet(ABStatement aStatement, short aResultSetNo) throws SQLException {
        super(aStatement.getResultSetType() == 1004 ? 16 : 0);
        this.mStatement = aStatement;
        this.mMetaData = null;
        this.mFetchSize = aStatement.getFetchSize();
        this.mMaxRows = aStatement.getMaxRows();
        this.mCurrentCursorPosition = -1;
        this.mCurrentFetchPosition = 0;
        this.mLastFetched = false;
        this.mConnection = (ABConnection)aStatement.getConnection();
        this.mResultSetType = aStatement.getResultSetType();
        this.mResultSetID = aResultSetNo;
        this.mMoveDirection = 0;
        this.mState = 0;
        this.initFetchedRowAndColNumber();
    }

    public boolean absolute(int aRowNo) throws SQLException {
        if (this.mMetaData != null) {
            this.mMetaData.initLastGetterColPos();
        }
        switch (this.mResultSetType) {
            case 1004: {
                ex.test(this.mMaxRows != 0 && aRowNo >= this.mMaxRows, (short)100);
                if (this.mMaxRows == 0) {
                    aRowNo = aRowNo < 0 ? this.mCurrentFetchPosition + aRowNo - 1 : --aRowNo;
                } else {
                    int n = aRowNo = aRowNo < 0 ? this.mCurrentFetchPosition + aRowNo % this.mMaxRows - 1 : --aRowNo;
                }
                if (!this.fetchAll() || aRowNo >= this.mCurrentFetchPosition) break;
                int idx = aRowNo / this.mFetchSize;
                this.mMetaData.readBufferIntoMetaData(this, idx);
                this.mCurrentCursorPosition = aRowNo;
                this.mBufferIndex = this.mCurrentCursorPosition % this.mFetchSize;
                if (this.mBufferIndex < 0) break;
                return true;
            }
            default: {
                ex.exception((short)103);
            }
        }
        return false;
    }

    public void afterLast() throws SQLException {
        ex.test(this.mResultSetType == 1003, (short)103);
        this.fetchAll();
        this.mCurrentCursorPosition = this.mCurrentFetchPosition;
    }

    public void beforeFirst() throws SQLException {
        ex.test(this.mResultSetType == 1003, (short)103);
        this.absolute(0);
    }

    public void cancelRowUpdates() throws SQLException {
        ex.exception((short)30);
    }

    public void clear() {
        this.mCurrentCursorPosition = -1;
        this.mBufferIndex = -1;
        this.mCurrentFetchPosition = 0;
        this.mMaxRows = this.mStatement.getMaxRows();
        this.mLastFetched = false;
        super.clear();
    }

    public void clearWarnings() throws SQLException {
        this.wn.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.mState == 1) {
            this.mConnection.close(this);
        }
        this.mState = 3;
        super.clear();
        this.mCurrentFetchPosition = 0;
        this.mCurrentCursorPosition = 0;
        this.wn.clearWarnings();
    }

    public void deleteRow() throws SQLException {
        ex.exception((short)103);
    }

    public int findColumn(String c) throws SQLException {
        int ret = this.mMetaData.getColumnNo(c);
        ex.test(ret <= 0, (short)19);
        return ret;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int c) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public Array getArray(String columnName) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public InputStream getAsciiStream(int c) throws SQLException {
        Object obj = this.getObject(c);
        if (obj != null) {
            if (obj instanceof Clob) {
                return ((Clob)obj).getAsciiStream();
            }
            ex.exception((short)103);
        }
        return null;
    }

    public InputStream getAsciiStream(String cname) throws SQLException {
        return this.getAsciiStream(this.getColumnNo(cname));
    }

    public BigDecimal getBigDecimal(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getBigDecimal(this.mBufferIndex);
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(column);
        ret.setScale(scale, 6);
        return ret;
    }

    public BigDecimal getBigDecimal(String cname) throws SQLException {
        return this.getBigDecimal(this.findColumn(cname));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(this.findColumn(columnName));
        ret.setScale(scale, 6);
        return ret;
    }

    public InputStream getBinaryStream(int c) throws SQLException {
        java.sql.Blob b = this.getBlob(c);
        if (b != null) {
            return b.getBinaryStream();
        }
        return null;
    }

    public InputStream getBinaryStream(String cname) throws SQLException {
        return this.getBinaryStream(this.findColumn(cname));
    }

    public java.sql.Blob getBlob(int c) throws SQLException {
        Blob v = this.mMetaData.getMetaColumn(c).blobValue(this.mBufferIndex);
        return v;
    }

    public java.sql.Blob getBlob(String cname) throws SQLException {
        return this.getBlob(this.findColumn(cname));
    }

    public boolean getBoolean(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.boolValue(this.mBufferIndex);
    }

    public boolean getBoolean(String cname) throws SQLException {
        return this.getBoolean(this.findColumn(cname));
    }

    public byte getByte(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.byteValue(this.mBufferIndex);
    }

    public byte getByte(String cname) throws SQLException {
        return this.getByte(this.findColumn(cname));
    }

    public byte[] getBytes(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.bytesValue(this.mBufferIndex);
    }

    public byte[] getBytes(String cname) throws SQLException {
        return this.getBytes(this.findColumn(cname));
    }

    public Reader getCharacterStream(int column) throws SQLException {
        String tmp = this.getString(column);
        if (tmp == null) {
            return null;
        }
        return new CharArrayReader(this.getString(column).toCharArray());
    }

    public Reader getCharacterStream(String cname) throws SQLException {
        return this.getCharacterStream(this.findColumn(cname));
    }

    public java.sql.Clob getClob(int c) throws SQLException {
        return this.mMetaData.getMetaColumn(c).clobValue(this.mBufferIndex);
    }

    public java.sql.Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public Date getDate(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getDate(this.mBufferIndex);
    }

    public Date getDate(int column, Calendar cal) throws SQLException {
        return this.getDate(column);
    }

    public Date getDate(String cname) throws SQLException {
        return this.getDate(this.getColumnNo(cname));
    }

    public Date getDate(String cname, Calendar cal) throws SQLException {
        return this.getDate(this.getColumnNo(cname), cal);
    }

    public double getDouble(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getDouble(this.mBufferIndex);
    }

    public double getDouble(String cname) throws SQLException {
        return this.getDouble(this.getColumnNo(cname));
    }

    public String getExplainPlan() throws SQLException {
        return this.mConnection.getExplainPlan(this);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.mFetchSize;
    }

    public float getFloat(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getFloat(this.mBufferIndex);
    }

    public float getFloat(String cname) throws SQLException {
        return this.getFloat(this.findColumn(cname));
    }

    public int getInt(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getInt(this.mBufferIndex);
    }

    public int getInt(String cname) throws SQLException {
        return this.getInt(this.findColumn(cname));
    }

    public long getLong(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getLong(this.mBufferIndex);
    }

    public long getLong(String cname) throws SQLException {
        return this.getLong(this.findColumn(cname));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.checkAndAllocateMeta()) {
            this.mConnection.meta(this);
        }
        return this.mMetaData;
    }

    public Object getObject(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getObject(this.mBufferIndex);
    }

    public Object getObject(int c, Map map) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public Object getObject(String cname) throws SQLException {
        return this.getObject(this.findColumn(cname));
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public Ref getRef(int c) throws SQLException {
        return null;
    }

    public Ref getRef(String columnName) throws SQLException {
        return null;
    }

    public int getRow() throws SQLException {
        return this.mCurrentCursorPosition + 1;
    }

    public short getShort(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getShort(this.mBufferIndex);
    }

    public short getShort(String cname) throws SQLException {
        return this.getShort(this.findColumn(cname));
    }

    public Statement getStatement() throws SQLException {
        return this.mStatement;
    }

    public String getString(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getString(this.mBufferIndex);
    }

    public String getString(String cname) throws SQLException {
        return this.getString(this.findColumn(cname));
    }

    public Time getTime(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getTime(this.mBufferIndex);
    }

    public Time getTime(int column, Calendar cal) throws SQLException {
        return this.getTime(column);
    }

    public Time getTime(String cname) throws SQLException {
        return this.getTime(this.findColumn(cname));
    }

    public Time getTime(String cname, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(cname), cal);
    }

    public Timestamp getTimestamp(int c) throws SQLException {
        BindMeta bc = this.mMetaData.getMetaColumn(c);
        return bc.getTimestamp(this.mBufferIndex);
    }

    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        return this.getTimestamp(column);
    }

    public Timestamp getTimestamp(String cname) throws SQLException {
        return this.getTimestamp(this.findColumn(cname));
    }

    public Timestamp getTimestamp(String cname, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(cname), cal);
    }

    public int getType() throws SQLException {
        return this.mResultSetType;
    }

    public InputStream getUnicodeStream(int c) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public InputStream getUnicodeStream(String column) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public URL getURL(int c) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        ex.exception((short)103);
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.wn.getWarnings();
    }

    public void insertRow() throws SQLException {
        ex.exception((short)103);
    }

    public boolean isAfterLast() throws SQLException {
        return this.mLastFetched && this.mCurrentCursorPosition >= this.mCurrentFetchPosition;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.mCurrentCursorPosition < 0;
    }

    public boolean isFirst() throws SQLException {
        return this.mCurrentCursorPosition == 0;
    }

    public boolean isLast() throws SQLException {
        return this.mLastFetched && this.mCurrentCursorPosition == this.mCurrentFetchPosition - 1;
    }

    public boolean last() throws SQLException {
        this.afterLast();
        return this.absolute(this.mCurrentCursorPosition);
    }

    public void moveToCurrentRow() throws SQLException {
        ex.exception((short)30);
    }

    public void moveToInsertRow() throws SQLException {
        ex.exception((short)30);
    }

    public boolean next() throws SQLException {
        boolean ret;
        if (this.mMetaData != null) {
            this.mMetaData.initLastGetterColPos();
        }
        if (ret = this.mMaxRows > 0 ? this.mCurrentCursorPosition < this.mMaxRows - 1 : true) {
            switch (this.mResultSetType) {
                case 1004: {
                    if (!this.mLastFetched) {
                        this.fetchAll();
                        this.mCurrentCursorPosition = -1;
                    }
                    boolean bl = ret = ++this.mCurrentCursorPosition < this.mCurrentFetchPosition;
                    if (!ret) break;
                    int idx = this.mCurrentCursorPosition / this.mFetchSize;
                    this.mMetaData.readBufferIntoMetaData(this, idx);
                    this.mBufferIndex = this.mCurrentCursorPosition % this.mFetchSize;
                    break;
                }
                case 1003: {
                    ret = this.fetchPosition();
                    break;
                }
                default: {
                    ex.exception((short)103);
                }
            }
        }
        return ret;
    }

    public boolean previous() throws SQLException {
        return this.absolute(this.mCurrentCursorPosition);
    }

    public void refreshRow() throws SQLException {
        ex.exception((short)103);
    }

    public boolean relative(int row) throws SQLException {
        return this.absolute(row += this.mCurrentCursorPosition + 1);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        ex.test(direction != 1000, (short)103);
    }

    public void setFetchSize(int rows) throws SQLException {
        ex.test(rows < 0 || rows >= Short.MAX_VALUE, (short)84);
        if (this.mResultSetType == 1003) {
            this.mFetchSize = (short)rows;
        }
    }

    void setMaxRows(int newMaxRows) {
        this.mMaxRows = newMaxRows;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("[");
        sb.append(this.mBufferIndex);
        sb.append("] ");
        if (this.mBufferIndex > -1) {
            for (int i = 1; i < this.mMetaData.size(); i = (int)((short)(i + 1))) {
                try {
                    sb.append(this.getMetaColumn(i).getString(this.mBufferIndex));
                    sb.append('|');
                    continue;
                }
                catch (SQLException e) {
                    sb.append(e.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public void updateArray(int c, Array x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateAsciiStream(int c, InputStream x, int length) throws SQLException {
        Object obj = this.getObject(c);
        if (obj instanceof Clob) {
            ((Clob)obj).setAsciiStream(x, length);
        } else {
            ex.exception((short)103);
        }
        ex.exception((short)103);
    }

    public void updateAsciiStream(String column, InputStream x, int length) throws SQLException {
        int c = this.getColumnNo(column);
        this.updateAsciiStream(c, x, length);
    }

    public void updateBigDecimal(int c, BigDecimal x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateBinaryStream(int c, InputStream in, int length) throws SQLException {
        Object obj = this.getObject(c);
        if (obj instanceof Blob) {
            ((Blob)obj).put(in, 0, length);
        } else {
            ex.exception((short)103);
        }
    }

    public void updateBinaryStream(String column, InputStream x, int length) throws SQLException {
        int c = this.getColumnNo(column);
        this.updateBinaryStream(c, x, length);
    }

    public void updateBlob(int c, java.sql.Blob x) throws SQLException {
        int length = (int)x.length();
        ex.test((long)length != x.length(), (short)35);
        this.updateBinaryStream(c, x.getBinaryStream(), length);
    }

    public void updateBlob(String column, java.sql.Blob x) throws SQLException {
        int c = this.getColumnNo(column);
        this.updateBlob(c, x);
    }

    public void updateBoolean(int c, boolean x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateByte(int c, byte x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateBytes(int c, byte[] x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateCharacterStream(int c, Reader x, int length) throws SQLException {
        Object obj = this.getObject(c);
        if (obj instanceof Clob) {
            ((Clob)obj).setCharacterStream(x, length);
        } else {
            ex.exception((short)103);
        }
    }

    public void updateCharacterStream(String column, Reader x, int length) throws SQLException {
        int c = this.getColumnNo(column);
        this.updateCharacterStream(c, x, length);
    }

    public void updateClob(int c, java.sql.Clob x) throws SQLException {
        int length = (int)x.length();
        ex.test((long)length != x.length(), (short)35);
        this.updateCharacterStream(c, x.getCharacterStream(), length);
    }

    public void updateClob(String column, java.sql.Clob x) throws SQLException {
        int c = this.getColumnNo(column);
        this.updateClob(c, x);
    }

    public void updateDate(int c, Date x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateDouble(int c, double x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateFloat(int c, float x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateInt(int c, int x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateLong(int c, long x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateNull(int c) throws SQLException {
        ex.exception((short)103);
    }

    public void updateNull(String columnName) throws SQLException {
        ex.exception((short)103);
    }

    public void updateObject(int c, Object x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateObject(int c, Object x, int scale) throws SQLException {
        ex.exception((short)103);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        ex.exception((short)103);
    }

    public void updateRef(int c, Ref x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateRow() throws SQLException {
        ex.exception((short)103);
    }

    public void updateShort(int c, short x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateString(int c, String x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateString(String columnName, String x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateTime(int c, Time x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateTimestamp(int c, Timestamp x) throws SQLException {
        ex.exception((short)103);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        ex.exception((short)103);
    }

    public boolean wasNull() throws SQLException {
        boolean sIsNull = false;
        short sLastGetterColPos = 0;
        if (this.mCurrentCursorPosition < 0) {
            throw new SQLException(SQLStates.mFixmsg[46]);
        }
        sLastGetterColPos = this.mMetaData.getLastGetterColPos();
        if (sLastGetterColPos <= 0) {
            throw new SQLException(SQLStates.mFixmsg[46]);
        }
        Object obj = this.mMetaData.get(sLastGetterColPos);
        sIsNull = ((BindMeta)obj).isNull(this.mBufferIndex);
        return sIsNull;
    }

    public void initFetchedRowAndColNumber() {
        this.mFetchedRowNum = 0;
        this.mFetchedColNum = 0;
    }

    public void incFetchedRowNumber() {
        ++this.mFetchedRowNum;
    }

    public void incFetchedColNumber() {
        this.mFetchedColNum = (short)(this.mFetchedColNum + 1);
    }

    public int getFetchedRowNumber() {
        return this.mFetchedRowNum;
    }

    public short getFetchedColNumber() {
        return this.mFetchedColNum;
    }

    public void setFetchedRowNumber(int aFetchedRowNum) {
        this.mFetchedRowNum = aFetchedRowNum;
    }

    public void setFetchedColNumber(short aFetchedColNum) {
        this.mFetchedColNum = aFetchedColNum;
    }

    private final int getColumnNo(String cname) throws SQLException {
        return this.mMetaData.getColumnNo(cname);
    }

    public void initFetchPosition(int aRowNo) throws SQLException {
        this.mBufferIndex = -1;
        this.mCurrentCursorPosition = -1;
        this.mCurrentFetchPosition = aRowNo;
    }

    private final boolean fetchPosition() throws SQLException {
        boolean v = true;
        if (this.mCurrentCursorPosition == this.mCurrentFetchPosition - 1) {
            if (this.mState == 2 || this.mState == 3) {
                v = false;
            } else {
                int sFetchedRowCount = this.mConnection.writeFetchRequest(this);
                this.mCurrentFetchPosition += sFetchedRowCount;
                v = sFetchedRowCount > 0;
                this.mBufferIndex = 0;
                if (this.mFetchSize != 0 && this.mFetchSize != sFetchedRowCount) {
                    this.mLastFetched = true;
                } else if (!v) {
                    this.mLastFetched = true;
                }
            }
        } else {
            if (this.mCurrentCursorPosition > this.mCurrentFetchPosition - 1) {
                return false;
            }
            ++this.mBufferIndex;
        }
        ++this.mCurrentCursorPosition;
        return v;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    final void addMetaColumn(BindMeta bm) throws SQLException {
        this.checkAndAllocateMeta();
        this.mMetaData.addMetaColumn(bm);
    }

    final BindMeta getMetaColumn(int aColNo) throws SQLException {
        return this.mMetaData.getMetaColumn(aColNo);
    }

    final boolean fetchAll() throws SQLException {
        if (!this.mLastFetched) {
            switch (this.mResultSetType) {
                case 1003: {
                    break;
                }
                case 1004: {
                    if (this.mState != 1) break;
                    this.mMetaData.allocNewFetchBuffer(this);
                    do {
                        int rows;
                        if ((rows = this.mConnection.writeFetchRequest(this)) <= 0) continue;
                        this.mMetaData.allocNewFetchBuffer(this);
                        this.mCurrentFetchPosition += rows;
                    } while (this.mState == 1);
                }
            }
            this.mCurrentCursorPosition = this.mCurrentFetchPosition;
            this.mLastFetched = true;
        }
        return this.mCurrentFetchPosition > 0;
    }

    final int getColumnCount() throws SQLException {
        return this.mMetaData.size() - 1;
    }

    final int getDataType(int aColumnNo) throws SQLException {
        return this.mMetaData.getMetaColumn(aColumnNo).getDataType();
    }

    ABResultSetMetaData getTableMetaData() {
        return this.mMetaData;
    }

    final short getResultSetID() {
        return this.mResultSetID;
    }

    final boolean checkAndAllocateMeta() throws SQLException {
        if (this.mMetaData == null) {
            this.mFetchSize = this.mStatement.getFetchSize();
            this.mMetaData = new ABResultSetMetaData(this.mStatement);
            return true;
        }
        return false;
    }

    final int moveFrom() {
        return this.mMoveDirection + 1;
    }

    final void setState(int aState) throws SQLException {
        ex.test(aState == this.mState, (short)23);
        this.mState = aState;
    }

    final int getStatementID() {
        return this.mStatement.getID();
    }

    public final int getFetchedRowCount() {
        return this.mCurrentFetchPosition;
    }
}

