/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.Geometry;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.ex;
import java.sql.SQLException;
import java.util.ArrayList;

public class GeometryList
extends ArrayList
implements Geometry {
    static final long serialVersionUID = 1L;
    protected int capacity = 0;
    protected double maxX = 0.0;
    protected double maxY = 0.0;
    protected String mGeometryName = "GEOMETRY";
    protected int mGeometrySize = 16;
    protected byte mGeometryType = 0;
    protected double minX = 0.0;
    protected double minY = 0.0;

    GeometryList(byte type) throws SQLException {
        this(type, 0);
    }

    GeometryList(byte type, int capacity) throws SQLException {
        super(capacity);
        this.capacity = capacity;
        this.mGeometryType = type;
        switch (type) {
            case 2: {
                this.mGeometryName = "LINESTRING";
                break;
            }
            case 3: {
                this.mGeometryName = "POLYGON";
                break;
            }
            case 4: {
                this.mGeometryName = "MULTIPOINT";
                break;
            }
            case 5: {
                this.mGeometryName = "MULTILINESTRING";
                break;
            }
            case 6: {
                this.mGeometryName = "MULTIPOLYGON";
                break;
            }
            case 7: {
                this.mGeometryName = "GEOCOLLECTION";
                break;
            }
            default: {
                ex.exception((short)106, SQLStates.mFixmsg[42]);
            }
        }
    }

    public String asText() {
        return "GEOMETRY(" + this.toString() + ')';
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    public boolean equals(Geometry obj) {
        for (int i = 0; i < this.size(); ++i) {
            if (obj.equals((Geometry)this.get(i))) continue;
            return false;
        }
        return true;
    }

    public byte geometryType() {
        return this.mGeometryType;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public int getSize() {
        return this.mGeometrySize;
    }

    public void resetMBR(Geometry p) {
        if (this.minX > p.getMinX()) {
            this.minX = p.getMinX();
        }
        if (this.minY > p.getMinY()) {
            this.minY = p.getMinY();
        }
        if (this.maxX < p.getMaxX()) {
            this.maxX = p.getMaxX();
        }
        if (this.maxY < p.getMaxY()) {
            this.maxY = p.getMaxY();
        }
    }

    void setSize(int inCapacity) {
        super.ensureCapacity(inCapacity);
        this.capacity = inCapacity;
    }
}

