/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.cmo;
import java.io.Serializable;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XID
implements Xid,
Serializable,
cmo {
    static final long serialVersionUID = 1L;
    static final byte XA_STATE_IDLE = 0;
    static final byte XA_STATE_ACTIVE = 1;
    static final byte XA_STATE_PREPARED = 2;
    static final byte XA_STATE_HCOMMITTED = 3;
    static final byte XA_STATE_HROLLBACKED = 4;
    static final byte XA_STATE_UNKNOWN = 5;
    private byte state;
    private long formatId;
    private byte[] branchId;
    private byte[] globalId;
    private long bLength;
    private long gLength;

    public XID() {
    }

    public XID(long aFormatID, byte[] aGlobalID, byte[] aBranchID, long aBLen, long aGLen) throws XAException {
        if (aGlobalID != null && aGlobalID.length > 64) {
            throw new XAException(-4);
        }
        if (aBranchID != null && aBranchID.length > 64) {
            throw new XAException(-4);
        }
        this.formatId = aFormatID;
        this.globalId = aGlobalID;
        this.branchId = aBranchID;
        this.bLength = aBLen;
        this.gLength = aGLen;
        this.state = (byte)5;
    }

    public XID(Xid xid) throws XAException {
        this.formatId = xid.getFormatId();
        this.globalId = xid.getGlobalTransactionId();
        this.branchId = xid.getBranchQualifier();
        if (this.globalId != null && this.globalId.length > 64) {
            throw new XAException(-4);
        }
        if (this.branchId != null && this.globalId.length > 64) {
            throw new XAException(-4);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Xid) {
            int i;
            Xid other = (Xid)obj;
            if (this.formatId != (long)other.getFormatId()) {
                return false;
            }
            byte[] otherGlobalID = other.getGlobalTransactionId();
            byte[] otherBranchID = other.getBranchQualifier();
            if (this.globalId.length != otherGlobalID.length || this.branchId.length != otherBranchID.length) {
                return false;
            }
            for (i = 0; i < this.globalId.length; ++i) {
                if (this.globalId[i] == otherGlobalID[i]) continue;
                return false;
            }
            for (i = 0; i < this.branchId.length; ++i) {
                if (this.branchId[i] == otherBranchID[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getBranchQualifier() {
        return this.branchId;
    }

    public int getFormatId() {
        return (int)this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalId;
    }

    public int getState() {
        return this.state;
    }

    public long getbLength() {
        return this.bLength;
    }

    public long getgLength() {
        return this.gLength;
    }

    public String toString() {
        return XID.toString(this);
    }

    public static String toString(Xid id) {
        if (id == null) {
            return "[NULL Xid]";
        }
        String s = id.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        s = s + "Xid::[ FormatId = " + id.getFormatId() + ", GlobalId = " + new String(id.getGlobalTransactionId()).trim() + ", BranchQual = " + new String(id.getBranchQualifier()).trim() + " ]";
        return s;
    }

    final void setState(byte state) {
        this.state = state;
    }

    static final String getStateName(int status) {
        String rs;
        switch (status) {
            case 0: {
                rs = "XA_STATE_IDLE";
                break;
            }
            case 1: {
                rs = "XA_STATE_ACTIVE";
                break;
            }
            case 2: {
                rs = "XA_STATE_PREPARED";
                break;
            }
            case 3: {
                rs = "XA_STATE_HCOMMITTED";
                break;
            }
            case 4: {
                rs = "XA_STATE_HROLLBACKED";
                break;
            }
            default: {
                rs = "XA_STATE_UNKNOWN";
            }
        }
        return rs;
    }
}

