/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import java.sql.SQLException;

public class TbBatchStreamDataWriter
extends TbStreamDataWriter {
    int sqlWriteSize = 0;

    public TbBatchStreamDataWriter(StreamBuffer buf, DataTypeConverter typeConverter) {
        super(buf, typeConverter);
    }

    public void setSql(String sql) throws SQLException {
        this.setCurDataSize(24);
        this.sqlWriteSize = sql != null ? this.writeLenAndDBEncodedPadString(sql) : this.writeInt(0, 4);
    }

    public void set(int totalArrayCnt, int arrayBindingCnt, int bindParamCnt, int flag, int autoCommit, int paramInfo_array_cnt, int paramInfoSize) throws SQLException {
        this.setCurDataSize(0);
        this.writeInt(31, 4);
        this.writeInt(this.getHeaderSize() + paramInfoSize - 24, 4);
        this.writeLong(autoCommit, 8);
        this.writeLong(0L, 8);
        this.setCurDataSize(24 + this.sqlWriteSize);
        this.writeInt(totalArrayCnt, 4);
        this.writeInt(arrayBindingCnt, 4);
        this.writeInt(bindParamCnt, 4);
        this.writeInt(flag, 4);
        this.writeInt(paramInfo_array_cnt, 4);
    }

    public void writeStreamBuffer(int kind, int dataType, byte[] dataValue) throws SQLException {
        int flag = kind & 0xFF;
        this.writeInt(flag |= dataType << 8 & 0xFFFFFF00, 4);
        if (dataValue == null) {
            this.writeRpcolData(null, 0);
        } else {
            this.writeRpcolData(dataValue, dataValue.length);
        }
    }

    public int getHeaderSize() {
        return this.sqlWriteSize + 24 + 20;
    }
}

