/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class TbDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 6545162651851145814L;
    private TbDriver driver = null;
    protected ConnectionInfo info = new ConnectionInfo();
    private boolean isExplicitURL = false;
    private boolean autoConnRecovery = false;

    public synchronized Reference getReference() throws NamingException {
        String dataSourceName;
        String description;
        String serverName;
        String networkProtocol;
        String url;
        String passwd;
        Reference ref = new Reference(this.getClass().getName(), "com.tmax.tibero.jdbc.ext.TbDataSourceFactory", null);
        String user = this.info.getUser();
        if (user != null) {
            ref.add(new StringRefAddr("user", user));
        }
        if ((passwd = this.info.getPassword()) != null) {
            ref.add(new StringRefAddr("password", passwd));
        }
        if ((url = this.info.getUrl()) != null && !url.equals("")) {
            ref.add(new StringRefAddr("url", url));
        }
        if ((networkProtocol = this.info.getNetworkProtocol()) != null && !networkProtocol.equals("")) {
            ref.add(new StringRefAddr("networkProtocol", networkProtocol));
        }
        if ((serverName = this.info.getServerName()) != null && !serverName.equals("")) {
            ref.add(new StringRefAddr("serverName", serverName));
        }
        ref.add(new StringRefAddr("tdu", Integer.toString(this.info.getTdu())));
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.info.getPortNumber())));
        String databaseName = this.info.getDatabaseName();
        if (databaseName != null && !databaseName.equals("")) {
            ref.add(new StringRefAddr("databaseName", this.info.getDatabaseName()));
        }
        if ((description = this.info.getDescription()) != null && !description.equals("")) {
            ref.add(new StringRefAddr("description", description));
        }
        if ((dataSourceName = this.info.getDataSourceName()) != null && !dataSourceName.equals("")) {
            ref.add(new StringRefAddr("dataSourceName", dataSourceName));
        }
        return ref;
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public synchronized Connection getConnection(String user, String password) throws SQLException {
        if (user != null) {
            this.info.setUser(user);
        }
        if (password != null) {
            this.info.setPassword(password);
        }
        if (this.driver == null) {
            this.driver = new TbDriver();
        }
        if (!this.isExplicitURL) {
            this.info.setUrl(TbUrlParser.makeURL(this.info));
        }
        Connection conn = this.driver.connect(this.info);
        return conn;
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return Debug.getLogWriter();
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return 0;
    }

    public synchronized void setLogWriter(PrintWriter writer) throws SQLException {
        Debug.setLogWriter(writer);
    }

    public synchronized void setLoginTimeout(int i) throws SQLException {
    }

    public synchronized String getDatabaseName() {
        return this.info.getDatabaseName();
    }

    public synchronized void setDatabaseName(String databaseName) {
        this.info.setDatabaseName(databaseName);
    }

    public synchronized String getDataSourceName() {
        return this.info.getDataSourceName();
    }

    public synchronized void setDataSourceName(String dataSourceName) {
        this.info.setDataSourceName(dataSourceName);
    }

    public synchronized String getDescription() {
        return this.info.getDescription();
    }

    public synchronized void setDescription(String description) {
        this.info.setDescription(description);
    }

    public synchronized String getNetworkProtocol() {
        return this.info.getNetworkProtocol();
    }

    public synchronized void setNetworkProtocol(String networkProtocol) {
        this.info.setNetworkProtocol(networkProtocol);
    }

    public synchronized String getPassword() {
        return this.info.getPassword();
    }

    public synchronized void setPassword(String password) {
        this.info.setPassword(password);
    }

    public synchronized int getPortNumber() {
        return this.info.getPortNumber();
    }

    public synchronized void setPortNumber(int portNumber) {
        this.info.setPortNumber(portNumber);
    }

    public synchronized String getRoleName() {
        return "";
    }

    public synchronized void setRoleName(String roleName) {
    }

    public synchronized String getServerName() {
        return this.info.getServerName();
    }

    public synchronized void setServerName(String serverName) {
        this.info.setServerName(serverName);
    }

    public synchronized String getUser() {
        return this.info.getUser();
    }

    public synchronized void setUser(String user) {
        this.info.setUser(user);
    }

    public synchronized int getTdu() {
        return this.info.getTdu();
    }

    public synchronized void setTdu(int tdu) {
        this.info.setTdu(tdu);
    }

    public synchronized String getURL() throws SQLException {
        if (!this.isExplicitURL) {
            this.info.setUrl(TbUrlParser.makeURL(this.info));
        }
        return this.info.getUrl();
    }

    public synchronized void setURL(String url) throws SQLException {
        ConnectionInfo info = TbUrlParser.parseUrl(url, null);
        this.info.setUrl(url);
        this.info.setDriverType(info.getDriverType());
        this.info.setServerName(info.getServerName());
        this.info.setPortNumber(info.getPortNumber());
        this.info.setDatabaseName(info.getDatabaseName());
        this.info.setFailOver(info.getFailOver());
        this.info.setBackupServerName(info.getBackupServerName());
        this.info.setBackupPortNumber(info.getBackupPortNumber());
        info = null;
        this.isExplicitURL = true;
    }

    public synchronized void setDriverType(String driverType) {
        this.info.setDriverType(driverType);
    }

    public synchronized String getDriverType() {
        return this.info.getDriverType();
    }

    public synchronized void setAutoConnectionRecoveryEnabled(boolean flag) throws SQLException {
        if (this.autoConnRecovery) {
            throw new TbSQLException(-90645);
        }
        this.autoConnRecovery = flag;
    }

    public synchronized boolean getAutoConnectionRecoveryEnabled() {
        return this.autoConnRecovery;
    }
}

