/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsgError;
import java.sql.SQLException;

public class TbMsgDplLoadStreamReply
extends TbMsgError {
    public int rowCnt;
    public int returnCode;
    public int dummy;
    public byte[] errorStack;
    public int errorStackLen;

    public TbMsgDplLoadStreamReply(int autoCommit) {
        this.msgType = 58;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int rowCnt, int returnCode, int dummy, byte[] errorStack, int errorStackLen) {
        this.rowCnt = rowCnt;
        this.returnCode = returnCode;
        this.dummy = dummy;
        this.errorStack = errorStack;
        this.errorStackLen = errorStackLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.rowCnt, 4);
        writer.writeInt(this.returnCode, 4);
        writer.writeInt(this.dummy, 4);
        if (this.errorStackLen != 0) {
            writer.writeInt(this.errorStackLen, 4);
            writer.writePadBytes(this.errorStack, 0, this.errorStackLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.rowCnt = reader.readInt32();
        this.returnCode = reader.readInt32();
        this.dummy = reader.readInt32();
        this.readErrorStackInfo(reader);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgDplLoadStreamReply msg = (TbMsgDplLoadStreamReply)obj;
        if (this.rowCnt != msg.rowCnt) {
            return false;
        }
        if (this.returnCode != msg.returnCode) {
            return false;
        }
        if (this.dummy != msg.dummy) {
            return false;
        }
        if (this.errorStack == null && msg.errorStack != null || this.errorStack != null && msg.errorStack == null) {
            return false;
        }
        if (this.errorStack != null && msg.errorStack != null) {
            if (this.errorStack.length != msg.errorStack.length) {
                return false;
            }
            for (int i = 0; i < msg.errorStack.length; ++i) {
                if (this.errorStack[i] == msg.errorStack[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgDplLoadStreamReply]/");
        str.append("rowCnt=");
        str.append(this.rowCnt);
        str.append("/");
        str.append("returnCode=");
        str.append(this.returnCode);
        str.append("/");
        str.append("dummy=");
        str.append(this.dummy);
        str.append("/");
        str.append("errorStack=");
        if (this.errorStack != null) {
            for (int i = 0; i < this.errorStack.length; ++i) {
                str.append(this.errorStack[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

