/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsgError;
import java.sql.SQLException;

public class TbMsgEreply
extends TbMsgError {
    public int flag;
    public byte[] errorStack;
    public int errorStackLen;

    public TbMsgEreply(int autoCommit) {
        this.msgType = 76;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int flag, byte[] errorStack, int errorStackLen) {
        this.flag = flag;
        this.errorStack = errorStack;
        this.errorStackLen = errorStackLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.flag, 4);
        if (this.errorStackLen != 0) {
            writer.writeInt(this.errorStackLen, 4);
            writer.writePadBytes(this.errorStack, 0, this.errorStackLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.flag = reader.readInt32();
        this.readErrorStackInfo(reader);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgEreply msg = (TbMsgEreply)obj;
        if (this.flag != msg.flag) {
            return false;
        }
        if (this.errorStack == null && msg.errorStack != null || this.errorStack != null && msg.errorStack == null) {
            return false;
        }
        if (this.errorStack != null && msg.errorStack != null) {
            if (this.errorStack.length != msg.errorStack.length) {
                return false;
            }
            for (int i = 0; i < msg.errorStack.length; ++i) {
                if (this.errorStack[i] == msg.errorStack[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgEreply]/");
        str.append("flag=");
        str.append(this.flag);
        str.append("/");
        str.append("errorStack=");
        if (this.errorStack != null) {
            for (int i = 0; i < this.errorStack.length; ++i) {
                str.append(this.errorStack[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

