/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgExecutePrefetchNoDescReply
extends TbMsg {
    public byte[] ppid = new byte[8];
    public int csrId;
    public int rowCnt;
    public int isFetchCompleted;
    public int rowChunkSize;

    public TbMsgExecutePrefetchNoDescReply(int autoCommit) {
        this.msgType = 12;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(byte[] ppid, int csrId, int rowCnt, int isFetchCompleted, int rowChunkSize) {
        this.ppid = ppid;
        this.csrId = csrId;
        this.rowCnt = rowCnt;
        this.isFetchCompleted = isFetchCompleted;
        this.rowChunkSize = rowChunkSize;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeBytes(this.ppid);
        writer.writeInt(this.csrId, 4);
        writer.writeInt(this.rowCnt, 4);
        writer.writeInt(this.isFetchCompleted, 4);
        writer.writeInt(this.rowChunkSize, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        reader.readBytes(this.ppid, 0, 8);
        this.csrId = reader.readInt32();
        this.rowCnt = reader.readInt32();
        this.isFetchCompleted = reader.readInt32();
        this.rowChunkSize = reader.readInt32();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgExecutePrefetchNoDescReply msg = (TbMsgExecutePrefetchNoDescReply)obj;
        if (this.ppid == null && msg.ppid != null || this.ppid != null && msg.ppid == null) {
            return false;
        }
        if (this.ppid != null && msg.ppid != null) {
            if (this.ppid.length != msg.ppid.length) {
                return false;
            }
            for (int i = 0; i < msg.ppid.length; ++i) {
                if (this.ppid[i] == msg.ppid[i]) continue;
                return false;
            }
        }
        if (this.csrId != msg.csrId) {
            return false;
        }
        if (this.rowCnt != msg.rowCnt) {
            return false;
        }
        if (this.isFetchCompleted != msg.isFetchCompleted) {
            return false;
        }
        return this.rowChunkSize == msg.rowChunkSize;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgExecutePrefetchNoDescReply]/");
        str.append("ppid=");
        if (this.ppid != null) {
            for (int i = 0; i < this.ppid.length; ++i) {
                str.append(this.ppid[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("csrId=");
        str.append(this.csrId);
        str.append("/");
        str.append("rowCnt=");
        str.append(this.rowCnt);
        str.append("/");
        str.append("isFetchCompleted=");
        str.append(this.isFetchCompleted);
        str.append("/");
        str.append("rowChunkSize=");
        str.append(this.rowChunkSize);
        str.append("/");
        return str.append("\n").toString();
    }
}

