/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgLobWrite
extends TbMsg {
    public int offsetHigh;
    public int offsetLow;
    public int packetPos;
    public byte[] slobLoc;
    public int slobLocLen;
    public byte[] data;
    public int dataLen;

    public TbMsgLobWrite(int autoCommit) {
        this.msgType = 41;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int offsetHigh, int offsetLow, int packetPos, byte[] slobLoc, int slobLocLen, byte[] data, int dataLen) {
        this.offsetHigh = offsetHigh;
        this.offsetLow = offsetLow;
        this.packetPos = packetPos;
        this.slobLoc = slobLoc;
        this.slobLocLen = slobLocLen;
        this.data = data;
        this.dataLen = dataLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.offsetHigh, 4);
        writer.writeInt(this.offsetLow, 4);
        writer.writeInt(this.packetPos, 4);
        if (this.slobLocLen != 0) {
            writer.writeInt(this.slobLocLen, 4);
            writer.writePadBytes(this.slobLoc, 0, this.slobLocLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        if (this.dataLen != 0) {
            writer.writeInt(this.dataLen, 4);
            writer.writePadBytes(this.data, 0, this.dataLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.offsetHigh = reader.readInt32();
        this.offsetLow = reader.readInt32();
        this.packetPos = reader.readInt32();
        int slobLocLen = reader.readInt32();
        if (slobLocLen != 0) {
            this.slobLoc = new byte[slobLocLen];
            reader.readPadBytes(this.slobLoc, 0, slobLocLen);
        } else {
            reader.moveReadOffset(4);
            this.slobLoc = new byte[0];
        }
        int dataLen = reader.readInt32();
        if (dataLen != 0) {
            this.data = new byte[dataLen];
            reader.readPadBytes(this.data, 0, dataLen);
        } else {
            reader.moveReadOffset(4);
            this.data = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbMsgLobWrite msg = (TbMsgLobWrite)obj;
        if (this.offsetHigh != msg.offsetHigh) {
            return false;
        }
        if (this.offsetLow != msg.offsetLow) {
            return false;
        }
        if (this.packetPos != msg.packetPos) {
            return false;
        }
        if (this.slobLoc == null && msg.slobLoc != null || this.slobLoc != null && msg.slobLoc == null) {
            return false;
        }
        if (this.slobLoc != null && msg.slobLoc != null) {
            if (this.slobLoc.length != msg.slobLoc.length) {
                return false;
            }
            for (i = 0; i < msg.slobLoc.length; ++i) {
                if (this.slobLoc[i] == msg.slobLoc[i]) continue;
                return false;
            }
        }
        if (this.data == null && msg.data != null || this.data != null && msg.data == null) {
            return false;
        }
        if (this.data != null && msg.data != null) {
            if (this.data.length != msg.data.length) {
                return false;
            }
            for (i = 0; i < msg.data.length; ++i) {
                if (this.data[i] == msg.data[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbMsgLobWrite]/");
        str.append("offsetHigh=");
        str.append(this.offsetHigh);
        str.append("/");
        str.append("offsetLow=");
        str.append(this.offsetLow);
        str.append("/");
        str.append("packetPos=");
        str.append(this.packetPos);
        str.append("/");
        str.append("slobLoc=");
        if (this.slobLoc != null) {
            for (i = 0; i < this.slobLoc.length; ++i) {
                str.append(this.slobLoc[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("data=");
        if (this.data != null) {
            for (i = 0; i < this.data.length; ++i) {
                str.append(this.data[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

