/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindParamDesc;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgPcSemanticCheck
extends TbMsg {
    public int stmtType;
    public String stmtText;
    public int bpInfoArrayCnt;
    public TbBindParamDesc[] bpInfo;

    public TbMsgPcSemanticCheck(int autoCommit) {
        this.msgType = 71;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int stmtType, String stmtText, int bpInfoArrayCnt, TbBindParamDesc[] bpInfo) {
        this.stmtType = stmtType;
        this.stmtText = stmtText;
        this.bpInfoArrayCnt = bpInfoArrayCnt;
        this.bpInfo = bpInfo;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.stmtType, 4);
        if (this.stmtText != null) {
            writer.writeLenAndDBEncodedPadString(this.stmtText);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.bpInfoArrayCnt, 4);
        if (this.bpInfo != null) {
            for (int i = 0; i < this.bpInfoArrayCnt; ++i) {
                this.bpInfo[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.stmtType = reader.readInt32();
        int stmtTextLen = reader.readInt32();
        this.stmtText = reader.readDBDecodedPadString(stmtTextLen);
        int bpInfoLen = reader.readInt32();
        if (bpInfoLen > 0) {
            this.bpInfo = new TbBindParamDesc[bpInfoLen];
            for (int i = 0; i < bpInfoLen; ++i) {
                this.bpInfo[i] = new TbBindParamDesc();
                this.bpInfo[i].deserialize(reader);
            }
        } else {
            this.bpInfo = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgPcSemanticCheck msg = (TbMsgPcSemanticCheck)obj;
        if (this.stmtType != msg.stmtType) {
            return false;
        }
        if (this.stmtText == null && msg.stmtText != null || this.stmtText != null && msg.stmtText == null) {
            return false;
        }
        if (this.stmtText != null && msg.stmtText != null && !this.stmtText.equals(msg.stmtText)) {
            return false;
        }
        if (this.bpInfo == null && msg.bpInfo != null || this.bpInfo != null && msg.bpInfo == null) {
            return false;
        }
        if (this.bpInfo != null && msg.bpInfo != null) {
            if (this.bpInfo.length != msg.bpInfo.length) {
                return false;
            }
            for (int i = 0; i < msg.bpInfo.length; ++i) {
                if (this.bpInfo[i].equals(msg.bpInfo[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgPcSemanticCheck]/");
        str.append("stmtType=");
        str.append(this.stmtType);
        str.append("/");
        str.append("stmtText=");
        str.append(this.stmtText);
        str.append("/");
        str.append("bpInfo={\n");
        if (this.bpInfo != null) {
            for (int i = 0; i < this.bpInfo.length; ++i) {
                str.append("  bpInfo[" + i + "]=" + this.bpInfo[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

