/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbBindparam;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgPrepareBatchupdate
extends TbMsg {
    public String sql;
    public int totalArrayCnt;
    public int arrayBindingCnt;
    public int bindParamCnt;
    public int flag;
    public int paramInfoArrayCnt;
    public TbBindparam[] paramInfo;

    public TbMsgPrepareBatchupdate(int autoCommit) {
        this.msgType = 31;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(String sql, int totalArrayCnt, int arrayBindingCnt, int bindParamCnt, int flag, int paramInfoArrayCnt, TbBindparam[] paramInfo) {
        this.sql = sql;
        this.totalArrayCnt = totalArrayCnt;
        this.arrayBindingCnt = arrayBindingCnt;
        this.bindParamCnt = bindParamCnt;
        this.flag = flag;
        this.paramInfoArrayCnt = paramInfoArrayCnt;
        this.paramInfo = paramInfo;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.sql != null) {
            writer.writeLenAndDBEncodedPadString(this.sql);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.totalArrayCnt, 4);
        writer.writeInt(this.arrayBindingCnt, 4);
        writer.writeInt(this.bindParamCnt, 4);
        writer.writeInt(this.flag, 4);
        writer.writeInt(this.paramInfoArrayCnt, 4);
        if (this.paramInfo != null) {
            for (int i = 0; i < this.paramInfoArrayCnt; ++i) {
                this.paramInfo[i].serialize(writer);
            }
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int sqlLen = reader.readInt32();
        this.sql = reader.readDBDecodedPadString(sqlLen);
        this.totalArrayCnt = reader.readInt32();
        this.arrayBindingCnt = reader.readInt32();
        this.bindParamCnt = reader.readInt32();
        this.flag = reader.readInt32();
        int paramInfoLen = reader.readInt32();
        if (paramInfoLen > 0) {
            this.paramInfo = new TbBindparam[paramInfoLen];
            for (int i = 0; i < paramInfoLen; ++i) {
                this.paramInfo[i] = new TbBindparam();
                this.paramInfo[i].deserialize(reader);
            }
        } else {
            this.paramInfo = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgPrepareBatchupdate msg = (TbMsgPrepareBatchupdate)obj;
        if (this.sql == null && msg.sql != null || this.sql != null && msg.sql == null) {
            return false;
        }
        if (this.sql != null && msg.sql != null && !this.sql.equals(msg.sql)) {
            return false;
        }
        if (this.totalArrayCnt != msg.totalArrayCnt) {
            return false;
        }
        if (this.arrayBindingCnt != msg.arrayBindingCnt) {
            return false;
        }
        if (this.bindParamCnt != msg.bindParamCnt) {
            return false;
        }
        if (this.flag != msg.flag) {
            return false;
        }
        if (this.paramInfo == null && msg.paramInfo != null || this.paramInfo != null && msg.paramInfo == null) {
            return false;
        }
        if (this.paramInfo != null && msg.paramInfo != null) {
            if (this.paramInfo.length != msg.paramInfo.length) {
                return false;
            }
            for (int i = 0; i < msg.paramInfo.length; ++i) {
                if (this.paramInfo[i].equals(msg.paramInfo[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgPrepareBatchupdate]/");
        str.append("sql=");
        str.append(this.sql);
        str.append("/");
        str.append("totalArrayCnt=");
        str.append(this.totalArrayCnt);
        str.append("/");
        str.append("arrayBindingCnt=");
        str.append(this.arrayBindingCnt);
        str.append("/");
        str.append("bindParamCnt=");
        str.append(this.bindParamCnt);
        str.append("/");
        str.append("flag=");
        str.append(this.flag);
        str.append("/");
        str.append("paramInfo={\n");
        if (this.paramInfo != null) {
            for (int i = 0; i < this.paramInfo.length; ++i) {
                str.append("  paramInfo[" + i + "]=" + this.paramInfo[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

