/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgTsamScanstartReply
extends TbMsg {
    public int scanid;
    public byte[] exactkey;
    public int exactkeyLen;

    public TbMsgTsamScanstartReply(int autoCommit) {
        this.msgType = 95;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int scanid, byte[] exactkey, int exactkeyLen) {
        this.scanid = scanid;
        this.exactkey = exactkey;
        this.exactkeyLen = exactkeyLen;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.scanid, 4);
        if (this.exactkeyLen != 0) {
            writer.writeInt(this.exactkeyLen, 4);
            writer.writePadBytes(this.exactkey, 0, this.exactkeyLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.scanid = reader.readInt32();
        int exactkeyLen = reader.readInt32();
        if (exactkeyLen != 0) {
            this.exactkey = new byte[exactkeyLen];
            reader.readPadBytes(this.exactkey, 0, exactkeyLen);
        } else {
            reader.moveReadOffset(4);
            this.exactkey = new byte[0];
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgTsamScanstartReply msg = (TbMsgTsamScanstartReply)obj;
        if (this.scanid != msg.scanid) {
            return false;
        }
        if (this.exactkey == null && msg.exactkey != null || this.exactkey != null && msg.exactkey == null) {
            return false;
        }
        if (this.exactkey != null && msg.exactkey != null) {
            if (this.exactkey.length != msg.exactkey.length) {
                return false;
            }
            for (int i = 0; i < msg.exactkey.length; ++i) {
                if (this.exactkey[i] == msg.exactkey[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgTsamScanstartReply]/");
        str.append("scanid=");
        str.append(this.scanid);
        str.append("/");
        str.append("exactkey=");
        if (this.exactkey != null) {
            for (int i = 0; i < this.exactkey.length; ++i) {
                str.append(this.exactkey[i] + "/");
            }
        } else {
            str.append("null/");
        }
        return str.append("\n").toString();
    }
}

