/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.method.AbstractFallbackMethodDefinitionSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MapBasedMethodDefinitionSource
extends AbstractFallbackMethodDefinitionSource
implements BeanClassLoaderAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$intercept$method$MapBasedMethodDefinitionSource == null ? (class$org$springframework$security$intercept$method$MapBasedMethodDefinitionSource = MapBasedMethodDefinitionSource.class$("org.springframework.security.intercept.method.MapBasedMethodDefinitionSource")) : class$org$springframework$security$intercept$method$MapBasedMethodDefinitionSource));
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    protected Map methodMap = new HashMap();
    private Map nameMap = new HashMap();
    static /* synthetic */ Class class$org$springframework$security$intercept$method$MapBasedMethodDefinitionSource;

    public MapBasedMethodDefinitionSource() {
    }

    public MapBasedMethodDefinitionSource(Map methodMap) {
        Iterator iterator = methodMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.addSecureMethod((String)entry.getKey(), (ConfigAttributeDefinition)entry.getValue());
        }
    }

    protected ConfigAttributeDefinition findAttributes(Class clazz) {
        return null;
    }

    protected ConfigAttributeDefinition findAttributes(Method method, Class targetClass) {
        if (targetClass == null) {
            return null;
        }
        return this.findAttributesSpecifiedAgainst(method, targetClass);
    }

    private ConfigAttributeDefinition findAttributesSpecifiedAgainst(Method method, Class clazz) {
        RegisteredMethod registeredMethod = new RegisteredMethod(method, clazz);
        if (this.methodMap.containsKey(registeredMethod)) {
            return (ConfigAttributeDefinition)this.methodMap.get(registeredMethod);
        }
        if (clazz.getSuperclass() != null) {
            return this.findAttributesSpecifiedAgainst(method, clazz.getSuperclass());
        }
        return null;
    }

    public void addSecureMethod(String name, ConfigAttributeDefinition attr) {
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String methodName = name.substring(lastDotIndex + 1);
        Assert.hasText((String)methodName, (String)("Method not found for '" + name + "'"));
        String typeName = name.substring(0, lastDotIndex);
        Class type = ClassUtils.resolveClassName((String)typeName, (ClassLoader)this.beanClassLoader);
        this.addSecureMethod(type, methodName, attr);
    }

    public void addSecureMethod(Class javaType, String mappedName, ConfigAttributeDefinition attr) {
        String name = javaType.getName() + '.' + mappedName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request to add secure method [" + name + "] with attributes [" + attr + "]"));
        }
        Method[] methods = javaType.getMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(mappedName) && !this.isMatch(methods[i].getName(), mappedName)) continue;
            matchingMethods.add(methods[i]);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + mappedName + "' on '" + javaType + "'");
        }
        Iterator it = matchingMethods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            RegisteredMethod registeredMethod = new RegisteredMethod(method, javaType);
            String regMethodName = (String)this.nameMap.get(registeredMethod);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (regMethodName != null) {
                    logger.debug((Object)("Replacing attributes for secure method [" + method + "]: current name [" + name + "] is more specific than [" + regMethodName + "]"));
                }
                this.nameMap.put(registeredMethod, name);
                this.addSecureMethod(registeredMethod, attr);
                continue;
            }
            logger.debug((Object)("Keeping attributes for secure method [" + method + "]: current name [" + name + "] is not more specific than [" + regMethodName + "]"));
        }
    }

    public void addSecureMethod(Class javaType, Method method, ConfigAttributeDefinition attr) {
        RegisteredMethod key = new RegisteredMethod(method, javaType);
        if (this.methodMap.containsKey(key)) {
            logger.debug((Object)("Method [" + method + "] is already registered with attributes [" + this.methodMap.get(key) + "]"));
            return;
        }
        this.methodMap.put(key, attr);
    }

    private void addSecureMethod(RegisteredMethod method, ConfigAttributeDefinition attr) {
        Assert.notNull((Object)method, (String)"RegisteredMethod required");
        Assert.notNull((Object)attr, (String)"Configuration attribute required");
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Adding secure method [" + method + "] with attributes [" + attr + "]"));
        }
        this.methodMap.put(method, attr);
    }

    public Collection getConfigAttributeDefinitions() {
        return Collections.unmodifiableCollection(this.methodMap.values());
    }

    private boolean isMatch(String methodName, String mappedName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1, mappedName.length()));
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        Assert.notNull((Object)beanClassLoader, (String)"Bean class loader required");
        this.beanClassLoader = beanClassLoader;
    }

    public int getMethodMapSize() {
        return this.methodMap.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RegisteredMethod {
        private Method method;
        private Class registeredJavaType;

        public RegisteredMethod(Method method, Class registeredJavaType) {
            Assert.notNull((Object)method, (String)"Method required");
            Assert.notNull((Object)registeredJavaType, (String)"Registered Java Type required");
            this.method = method;
            this.registeredJavaType = registeredJavaType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof RegisteredMethod) {
                RegisteredMethod rhs = (RegisteredMethod)obj;
                return this.method.equals(rhs.method) && this.registeredJavaType.equals(rhs.registeredJavaType);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() * this.registeredJavaType.hashCode();
        }

        public String toString() {
            return "RegisteredMethod[" + this.registeredJavaType.getName() + "; " + this.method + "]";
        }
    }
}

