/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbError;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class TbLobOutputStream
extends OutputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private boolean isBlob = true;
    private byte[] byteBuf = null;
    private char[] charBuf = null;

    public TbLobOutputStream(TbLob lob, long pos) throws SQLException {
        if (lob == null || pos < 1L) {
            throw new TbSQLException(-590713);
        }
        this.lob = lob;
        this.lobOffset = pos - 1L;
        this.bufOffset = 0;
        this.opened = true;
        if (lob instanceof TbClob) {
            this.charBuf = new char[TbLob.MAX_CHUNK_SIZE];
            this.isBlob = false;
        } else if (lob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.MAX_CHUNK_SIZE];
            this.isBlob = true;
        } else {
            throw new TbSQLException(-590713);
        }
    }

    private void assertOpen() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    private int getRemainedInBuffer() {
        if (this.isBlob) {
            return TbLob.MAX_CHUNK_SIZE - this.bufOffset;
        }
        return TbLob.MAX_CHUNK_SIZE - this.bufOffset;
    }

    private void flushBuffer() throws SQLException {
        int writeNum = 0;
        writeNum = this.isBlob ? ((TbBlob)this.lob).setBytes(this.lobOffset + 1L, this.byteBuf, 0, this.bufOffset) : ((TbClob)this.lob).putChars(this.lobOffset + 1L, this.charBuf, 0L, this.bufOffset);
        this.lobOffset += (long)writeNum;
        this.bufOffset = 0;
    }

    public void write(int b) throws IOException {
        this.assertOpen();
        if (this.getRemainedInBuffer() == 0) {
            try {
                this.flushBuffer();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (this.isBlob) {
            this.byteBuf[this.bufOffset++] = (byte)b;
        } else {
            this.charBuf[this.bufOffset++] = (char)b;
        }
    }

    public void close() throws IOException {
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        this.opened = false;
    }

    public void flush() throws IOException {
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }
}

