/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbPacketHeader {
    public static final int HEADER_SIZE = 80;
    private static final int STR_FIELD_SIZE = 32;
    private static final int MAGIC_FIELD = 0;
    private static final int MSGTYPE_FIELD = 1;
    private static final int MSGLEN_FIELD = 2;
    private static final int RCODE_FIELD = 3;
    private static final int CLID_FIELD = 4;
    private static final int ASIZE_FIELD = 5;
    private static final int FLD1_FIELD = 6;
    private static final int FLD2_FIELD = 7;
    private static final int FLD3_FIELD = 8;
    private static final int FLD4_FIELD = 9;
    private static final int FLD5_FIELD = 10;
    private static final int FLD6_FIELD = 11;
    private static final int STR_FIELD = 12;
    private byte[] header = new byte[80];

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("magic[").append(this.getIntField(0)).append("]");
        buf.append("msgtype[").append(this.getIntField(1)).append("]");
        buf.append("msglen[").append(this.getIntField(2)).append("]");
        buf.append("rcode[").append(this.getIntField(3)).append("]");
        buf.append("clid[").append(this.getIntField(4)).append("]");
        buf.append("asize[").append(this.getIntField(5)).append("]");
        buf.append("fld1[").append(this.getIntField(6)).append("]");
        buf.append("fld2[").append(this.getIntField(7)).append("]");
        buf.append("fld3[").append(this.getIntField(8)).append("]");
        buf.append("fld4[").append(this.getIntField(9)).append("]");
        buf.append("fld5[").append(this.getIntField(10)).append("]");
        buf.append("fld6[").append(this.getIntField(11)).append("]");
        buf.append("str[").append(this.getStrField()).append("]");
        return buf.toString();
    }

    public void init(int msgType, int msgLen, int clid) throws SQLException {
        for (int i = 0; i < 80; ++i) {
            this.header[i] = 0;
        }
        this.setIntField(0, 9999);
        this.setIntField(1, msgType);
        this.setIntField(2, msgLen);
        this.setIntField(4, clid);
    }

    public boolean equals(Object obj) {
        TbPacketHeader hdr = (TbPacketHeader)obj;
        return this.getMsgType() == hdr.getMsgType();
    }

    public byte[] getBytes() {
        return this.header;
    }

    private int getIntField(int fieldId) {
        return TbCommon.byte2int(this.getBytes(), fieldId * 4, 4);
    }

    private void setIntField(int fieldId, int value) {
        TbCommon.int2bytes(value, this.getBytes(), fieldId * 4, 4);
    }

    public int getMagic() {
        return this.getIntField(0);
    }

    public int getMsgType() {
        return this.getIntField(1);
    }

    public int getMsgLen() {
        return this.getIntField(2);
    }

    public int getRcode() {
        return this.getIntField(3);
    }

    public int getClientID() {
        return this.getIntField(4);
    }

    public int getFLD1() {
        return this.getIntField(6);
    }

    public int getFLD2() {
        return this.getIntField(7);
    }

    public int getFLD3() {
        return this.getIntField(8);
    }

    public int getFLD4() {
        return this.getIntField(9);
    }

    public int getFLD5() {
        return this.getIntField(10);
    }

    public int getFLD6() {
        return this.getIntField(11);
    }

    public void setMagic(int val) {
        this.setIntField(0, val);
    }

    public void setMsgType(int val) {
        this.setIntField(1, val);
    }

    public void setMsgLen(int val) {
        this.setIntField(2, val);
    }

    public void setClientID(int val) {
        this.setIntField(4, val);
    }

    public void setFLD1(int val) {
        this.setIntField(6, val);
    }

    public void setFLD2(int val) {
        this.setIntField(7, val);
    }

    public void setFLD3(int val) {
        this.setIntField(8, val);
    }

    public void setFLD4(int val) {
        this.setIntField(9, val);
    }

    public void setFLD5(int val) {
        this.setIntField(10, val);
    }

    public byte[] getStrField() {
        byte[] name = new byte[32];
        System.arraycopy(this.getBytes(), 48, name, 0, 32);
        return name;
    }

    public void setStrField(byte[] name) {
        this.setStrField(name, 0);
    }

    public void setStrField(byte[] name, int offset) {
        if (name == null) {
            return;
        }
        System.arraycopy(name, offset, this.getBytes(), 48, 32);
    }
}

