/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.BindItem;
import java.sql.SQLException;

public class BindData {
    protected BindItem[] bindItems = null;
    protected int deferredParamCnt = 0;

    public BindData(int fixedLength) throws SQLException {
        if (fixedLength < 0) {
            throw new TbSQLException(-90608, " length < 0 ");
        }
        this.bindItems = new BindItem[fixedLength];
        for (int i = 0; i < fixedLength; ++i) {
            this.bindItems[i] = new BindItem();
        }
    }

    public String ToString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.toString());
        int len = this.bindItems == null ? 0 : this.bindItems.length;
        for (int i = 0; i < len; ++i) {
            buf.append("[").append(i).append("]").append(this.bindItems[i].ToString());
        }
        return buf.toString();
    }

    public void reset() {
        if (this.bindItems == null) {
            return;
        }
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].close();
            this.bindItems[i] = null;
        }
        this.bindItems = null;
    }

    public void reuse() {
        if (this.bindItems == null) {
            return;
        }
        int len = this.bindItems.length;
        for (int i = 0; i < len; ++i) {
            this.bindItems[i].reuse();
        }
        this.deferredParamCnt = 0;
    }

    private void checkValid(int pos) throws SQLException {
        if (pos < 0 || this.bindItems == null || pos >= this.bindItems.length) {
            throw new TbSQLException(-90609);
        }
    }

    public void setBindItem(int pos, int kind, int sqlType) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].set(kind, sqlType);
    }

    public void setBindItem(int pos, int kind, int length, Object object, int dataType) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].setData(kind, length, object, dataType);
    }

    public void setBindItemNull(int pos, int kind, int dataType) throws SQLException {
        this.checkValid(pos);
        this.bindItems[pos].setData(kind, 0, null, dataType);
    }

    public void setFormOfUse(int pos, short form) {
        this.bindItems[pos].setForm(form);
    }

    public short getFormOfUse(int pos) {
        if (this.bindItems == null) {
            return 0;
        }
        return this.bindItems[pos].getForm();
    }

    public BindItem[] getBindItem() {
        return this.bindItems;
    }

    public BindItem getBindItem(int pos) throws SQLException {
        this.checkValid(pos);
        return this.bindItems[pos];
    }

    public boolean isOutParameterOn(int pos) throws SQLException {
        this.checkValid(pos);
        return this.bindItems[pos].isOutParameterOn();
    }

    public boolean isInParameterOn(int pos) throws SQLException {
        this.checkValid(pos);
        return this.bindItems[pos].isInParameterOn();
    }

    public int getParameterCnt() {
        return this.bindItems.length;
    }

    public int getOutParameterCnt() {
        int paramCnt = this.getParameterCnt();
        int cnt = 0;
        for (int i = 0; i < paramCnt; ++i) {
            if (!this.bindItems[i].isOutParameterOn()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getInParameterCnt() {
        int paramCnt = this.getParameterCnt();
        int cnt = 0;
        for (int i = 0; i < paramCnt; ++i) {
            if (!this.bindItems[i].isInParameterOn()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getInOutParameterCnt() {
        int paramCnt = this.getParameterCnt();
        int cnt = 0;
        for (int i = 0; i < paramCnt; ++i) {
            if (!this.bindItems[i].isOutParameterOn() || !this.bindItems[i].isInParameterOn()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getDeferredParamCnt() {
        return this.deferredParamCnt;
    }

    public int incDeferredParamCnt() {
        return this.deferredParamCnt++;
    }

    public void resetDeferredParamCnt() {
        this.deferredParamCnt = 0;
    }
}

