/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbRowId {
    long sgmt;
    long block;
    int file;
    int row;
    static final int ROWID_SGMT_BYTE_CNT = 4;
    static final int ROWID_BLOCK_BYTE_CNT = 4;
    static final int ROWID_FILE_BYTE_CNT = 2;
    static final int ROWID_ROW_BYTE_CNT = 2;
    static final int ROWID_ENCODING_BASE = 64;
    static final byte[] rowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final int ROWID_REMAINDER_BIT = 63;
    static final int ROWID_DIVISION_SHIFT = 6;
    static final int ROWID_SGMT_LEN = 6;
    static final int ROWID_FILE_LEN = 3;
    static final int ROWID_BLOCK_LEN = 6;
    static final int ROWID_ROW_LEN = 3;
    static final int ROWID_SGMT_LAST = 5;
    static final int ROWID_FILE_LAST = 8;
    static final int ROWID_BLOCK_LAST = 14;
    static final int ROWID_ROW_LAST = 17;
    static final int ROWID_LEN = 18;
    static final int ROWID_BYTE_CNT = 12;
    static final long ROWID_SGMT_MAX = Integer.MAX_VALUE;
    static final long ROWID_BLOCK_MAX = Integer.MAX_VALUE;
    static final int ROWID_FILE_MAX = 65535;
    static final int ROWID_ROW_MAX = 65535;

    public void setRowIdFields(long sgmt, long block, int file, int row) {
        this.sgmt = sgmt;
        this.block = block;
        this.file = file;
        this.row = row;
    }

    public String toString() {
        int n;
        byte[] erowid = new byte[18];
        for (n = 5; n >= 0; --n) {
            erowid[n] = rowid_encoding[(int)this.sgmt & 0x3F];
            this.sgmt >>= 6;
            erowid[9 + n] = rowid_encoding[(int)this.block & 0x3F];
            this.block >>= 6;
        }
        for (n = 8; n > 5; --n) {
            erowid[n] = rowid_encoding[this.file & 0x3F];
            this.file >>= 6;
            erowid[9 + n] = rowid_encoding[this.row & 0x3F];
            this.row >>= 6;
        }
        return new String(erowid);
    }

    public byte[] getServerBytes(int serverEndian, String data) throws SQLException {
        this.stringToRowid(data);
        byte[] erowid = new byte[12];
        if (serverEndian == 1) {
            TbCommon.long2bytes(this.sgmt, erowid, 0, 4);
            TbCommon.long2bytes(this.block, erowid, 4, 4);
            TbCommon.int2bytes(this.file, erowid, 8, 2);
            TbCommon.int2bytes(this.row, erowid, 10, 2);
        } else {
            TbCommon.long2bytesR(this.sgmt, erowid, 0, 4);
            TbCommon.long2bytesR(this.block, erowid, 4, 4);
            TbCommon.int2bytesR(this.file, erowid, 8, 2);
            TbCommon.int2bytesR(this.row, erowid, 10, 2);
        }
        return erowid;
    }

    public void byteToRowId(int serverEndian, byte[] bytes, int offset) throws SQLException {
        this.setRowIdFields(0L, 0L, 0, 0);
        if (serverEndian == 1) {
            this.sgmt = TbCommon.byte2long(bytes, offset, 4);
            this.block = TbCommon.byte2long(bytes, offset += 4, 4);
            this.file = TbCommon.byte2int(bytes, offset += 4, 2);
            this.row = TbCommon.byte2int(bytes, offset += 2, 2);
        } else if (serverEndian == 0) {
            this.sgmt = TbCommon.byte2longR(bytes, offset, 4);
            this.block = TbCommon.byte2longR(bytes, offset += 4, 4);
            this.file = TbCommon.byte2intR(bytes, offset += 4, 2);
            this.row = TbCommon.byte2intR(bytes, offset += 2, 2);
        }
    }

    public void stringToRowid(String data) throws SQLException {
        int c;
        byte[] bytes = data.getBytes();
        this.setRowIdFields(0L, 0L, 0, 0);
        long k = 1L;
        int n = 5;
        while (n >= 0) {
            c = TbRowId.makeRowIdToInt(bytes[n]);
            if (c < 0) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            if (Integer.MAX_VALUE - this.sgmt < k * (long)c) {
                throw new TbSQLException(-90642, "invaild segment number");
            }
            this.sgmt += k * (long)c;
            c = TbRowId.makeRowIdToInt(bytes[9 + n]);
            if (c < 0) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            if (Integer.MAX_VALUE - this.block < k * (long)c) {
                throw new TbSQLException(-90642, "wrong rowid segment information");
            }
            this.block += k * (long)c;
            --n;
            k <<= 6;
        }
        int l = 1;
        n = 8;
        while (n > 5) {
            c = TbRowId.makeRowIdToInt(bytes[n]);
            if (c < 0) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            if (65535 - this.file < l * c) {
                throw new TbSQLException(-90642, "invaild file file number");
            }
            this.file += l * c;
            c = TbRowId.makeRowIdToInt(bytes[9 + n]);
            if (c < 0) {
                throw new TbSQLException(-90642, "invaild rowid");
            }
            if (65535 - this.row < l * c) {
                throw new TbSQLException(-90642, "wriong rowid row");
            }
            this.row += l * c;
            --n;
            l <<= 6;
        }
    }

    private static int makeRowIdToInt(byte c) {
        return 65 <= c && c <= 90 ? c - 65 + 0 : (97 <= c && c <= 122 ? c - 97 + 26 : (48 <= c && c <= 57 ? c - 48 + 52 : (43 == c ? 62 : (47 == c ? 63 : -1))));
    }
}

