/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;

public class CharToByteDoubleByte {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected short[] index1;
    protected String[] index2;

    public boolean canConvert(char c) {
        byte[] abyte0 = new byte[2];
        if (c == '\u0000' || this.convSingleByte(c, abyte0) != 0) {
            return true;
        }
        return this.getNative(c) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int convert(char[] ac, int i, int j, byte[] abyte0, int k, int l) throws TbSQLException {
        int charOff = 0;
        int byteOff = 0;
        char highHalfZoneCode = '\u0000';
        byte[] abyte2 = new byte[2];
        charOff = i;
        byteOff = k;
        if (highHalfZoneCode != '\u0000') {
            highHalfZoneCode = '\u0000';
            if (ac[i] < '\udc00' || ac[i] > '\udfff') throw new TbSQLException(-590714, "Malformed input");
            if (!this.subMode) throw new TbSQLException(-590714, "Unknown character");
            int i1 = this.subBytes.length;
            if (byteOff + i1 > l) {
                throw new TbSQLException(-590714, "Conversion buffer overflow");
            }
            for (int k1 = 0; k1 < this.subBytes.length; ++k1) {
                abyte0[byteOff++] = this.subBytes[k1];
            }
            ++charOff;
        }
        while (charOff < j) {
            int j1;
            int byte1 = 1;
            byte[] abyte1 = abyte2;
            char c1 = ac[charOff];
            if (c1 >= '\ud800' && c1 <= '\udbff') {
                if (charOff + 1 >= j) {
                    highHalfZoneCode = c1;
                    return byteOff - k;
                }
                c1 = ac[charOff + 1];
                if (c1 < '\udc00' || c1 > '\udfff') throw new TbSQLException(-590714, "Malformed input");
                if (!this.subMode) throw new TbSQLException(-590714, "Unknown character");
                abyte1 = this.subBytes;
                j1 = this.subBytes.length;
                byte1 = 2;
            } else {
                if (c1 >= '\udc00' && c1 <= '\udfff') {
                    throw new TbSQLException(-590714, "Malformed input");
                }
                j1 = this.convSingleByte(c1, abyte1);
                if (j1 == 0) {
                    int l1 = this.getNative(c1);
                    if (l1 != 0) {
                        abyte1[0] = (byte)((l1 & 0xFF00) >> 8);
                        abyte1[1] = (byte)(l1 & 0xFF);
                        j1 = 2;
                    } else {
                        if (!this.subMode) throw new TbSQLException(-590714, "Unknown character");
                        abyte1 = this.subBytes;
                        j1 = this.subBytes.length;
                    }
                }
            }
            if (byteOff + j1 > l) {
                throw new TbSQLException(-590714, "Conversion buffer overflow");
            }
            for (int i2 = 0; i2 < j1; ++i2) {
                abyte0[byteOff++] = abyte1[i2];
            }
            charOff += byte1;
        }
        return byteOff - k;
    }

    protected int convSingleByte(char c, byte[] abyte0) {
        if (c < '\u0080') {
            abyte0[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    public short[] getIndex1() {
        return this.index1;
    }

    public String[] getIndex2() {
        return this.index2;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    protected int getNative(char c) {
        int i = this.index1[(c & 0xFF00) >> 8] << 8;
        return this.index2[i >> 12].charAt((i & 0xFFF) + (c & 0xFF));
    }
}

