/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.SJISCharToByteConverter;
import java.sql.SQLException;

public class SJISEncoder
implements CharsetEncoder {
    private SJISCharToByteConverter conv = new SJISCharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        return this.conv.convert(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws TbSQLException {
        return 0;
    }

    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (this.isEndingByte(byteArr, offset)) {
            return offset;
        }
        return offset + 1;
    }

    public int getLeadingBytePos(byte[] byteArr, int offset) {
        if (this.isLeadingByte(byteArr, offset)) {
            return offset;
        }
        return offset - 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (this.isSingleByte(byteArr[offset])) {
            return true;
        }
        return !this.isLeadingByte(byteArr, offset);
    }

    public boolean isLeadingByte(byte[] byteArr, int offset) {
        int i = offset;
        while (!(i - 1 < 0 || this.isSingleByte(byteArr[i]) && this.isSingleByte(byteArr[i - 1]))) {
            --i;
        }
        while (i <= offset) {
            if (!this.isSingleByte(byteArr[i])) {
                if (i + 1 == offset) {
                    return false;
                }
                ++i;
            } else if (i == offset) {
                return true;
            }
            ++i;
        }
        return true;
    }

    private boolean isSingleByte(byte value) {
        if (value < 128) {
            return true;
        }
        return value >= 161 && value < 224;
    }

    public byte[] stringToBytes(String srcStr) throws SQLException {
        char[] srcArr = srcStr.toCharArray();
        byte[] temp = new byte[srcArr.length * this.getMaxBytesPerChar()];
        int byteLen = this.charsToBytes(srcArr, 0, srcArr.length, temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    public byte[] stringToFixedBytes(String string) throws SQLException {
        return null;
    }
}

