/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.TbSQLException;
import com.tmax.tibero.jdbc.dpl.TbDirColumnMeta;
import java.sql.SQLException;

public class TbDirPathMetaData {
    public static final boolean NO_LOG = false;
    public static final boolean LOG = true;
    public static final int NO_BIND = 0;
    public static final int BIND = 256;
    public static final int MANUAL = 0;
    public static final int AUTO = 16;
    public static final int COMPLETE = 0;
    public static final int PARTIAL = 1;
    public static final int INIT_BUF_SIZE = 131072;
    public static final int CHAR_BUF_SIZE = 4096;
    public static final int BYTE_BUF_SIZE = 16384;
    private String schema;
    private String table;
    private int columnCnt;
    private boolean logFlag = false;
    private String clientCharSet = null;
    private int bufferSize = 131072;
    private String[] columnNames;
    private TbDirColumnMeta[] dirColumnMeta;

    public TbDirPathMetaData(String schema, String table, String[] columnNames, boolean logFlag) throws SQLException {
        this.setSchema(schema);
        this.setTable(table);
        this.columnNames = columnNames;
        this.logFlag = logFlag;
        this.columnCnt = columnNames.length;
        for (int i = 0; i < this.columnCnt; ++i) {
            this.setColumn(i + 1, columnNames[i]);
        }
        this.makeColumnMeta(this.columnCnt);
    }

    public TbDirPathMetaData() {
        this.reset();
    }

    public void reset() {
        this.schema = null;
        this.table = null;
        this.columnCnt = 0;
        this.logFlag = false;
        this.clientCharSet = null;
        this.columnNames = null;
        this.dirColumnMeta = null;
    }

    public void checkDirPathMetaData() throws SQLException {
        if (this.schema == null || this.schema.equals("")) {
            throw new TbSQLException(-90637);
        }
        if (this.table == null || this.table.equals("")) {
            throw new TbSQLException(-90638);
        }
        if (this.columnNames == null || this.columnNames.equals("")) {
            throw new TbSQLException(-90640);
        }
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i] != null && !this.columnNames[i].equals("")) continue;
            throw new TbSQLException(-90640);
        }
    }

    private void makeColumnMeta(int columnCnt) {
        this.dirColumnMeta = new TbDirColumnMeta[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            this.dirColumnMeta[i] = new TbDirColumnMeta();
        }
    }

    public TbDirColumnMeta[] getDirColumnMeta() {
        return this.dirColumnMeta;
    }

    public int getDataType(int columnIdx) throws SQLException {
        this.checkParameterIndex(columnIdx);
        return this.dirColumnMeta[columnIdx - 1].getDataType();
    }

    public int getColumnCnt() {
        return this.columnNames.length;
    }

    public void setColumnCnt(int columnCnt) {
        this.columnCnt = columnCnt;
        if (this.columnNames == null) {
            this.columnNames = new String[columnCnt];
            for (int i = 0; i < columnCnt; ++i) {
                this.columnNames[i] = new String();
            }
        }
        this.makeColumnMeta(columnCnt);
    }

    public void setColumn(int columnIdx, String columnName) throws SQLException {
        if (this.columnNames == null) {
            throw new TbSQLException(-90640);
        }
        this.checkParameterIndex(columnIdx);
        this.columnNames[columnIdx - 1] = this.getDBString(columnName);
    }

    public String getColumn(int columnIdx) throws SQLException {
        if (this.columnNames == null) {
            throw new TbSQLException(-90640);
        }
        this.checkParameterIndex(columnIdx);
        return this.columnNames[columnIdx - 1];
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) throws SQLException {
        if (table == null || table.equals("")) {
            throw new TbSQLException(-90638);
        }
        this.table = this.getDBString(table);
    }

    private String getDBString(String token) {
        int startQuoteIndex = token.indexOf(34);
        int endQuoteIndex = token.lastIndexOf(34);
        token = endQuoteIndex > startQuoteIndex ? token.substring(startQuoteIndex + 1, endQuoteIndex) : token.toUpperCase();
        return token;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) throws SQLException {
        if (schema == null || schema.equals("")) {
            throw new TbSQLException(-90637);
        }
        this.schema = this.getDBString(schema);
    }

    public boolean isLogFlag() {
        return this.logFlag;
    }

    public void setLogFlag(boolean logFlag) {
        this.logFlag = logFlag;
    }

    public String getClientCharSet() {
        return this.clientCharSet;
    }

    public void setClientCharSet(String clientCharSet) {
        this.clientCharSet = clientCharSet;
    }

    private void checkParameterIndex(int index) throws SQLException {
        if (index < 1 || index > this.columnCnt) {
            throw new TbSQLException(-90609);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

