/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgConnectReply
extends TbMsg {
    public int charset;
    public int svrIsBigendian;
    public int svrIsNanobase;
    public int tbMajor;
    public int tbMinor;
    public String tbProductName;
    public String tbProductVersion;
    public int mthrPid;
    public int cps;
    public int ncharset;

    public TbMsgConnectReply(int autoCommit) {
        this.msgType = 0;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(int charset, int svrIsBigendian, int svrIsNanobase, int tbMajor, int tbMinor, String tbProductName, String tbProductVersion, int mthrPid, int cps, int ncharset) {
        this.charset = charset;
        this.svrIsBigendian = svrIsBigendian;
        this.svrIsNanobase = svrIsNanobase;
        this.tbMajor = tbMajor;
        this.tbMinor = tbMinor;
        this.tbProductName = tbProductName;
        this.tbProductVersion = tbProductVersion;
        this.mthrPid = mthrPid;
        this.cps = cps;
        this.ncharset = ncharset;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        writer.writeInt(this.charset, 4);
        writer.writeInt(this.svrIsBigendian, 4);
        writer.writeInt(this.svrIsNanobase, 4);
        writer.writeInt(this.tbMajor, 4);
        writer.writeInt(this.tbMinor, 4);
        if (this.tbProductName != null) {
            writer.writeLenAndDBEncodedPadString(this.tbProductName);
        } else {
            writer.writeInt(0, 4);
        }
        if (this.tbProductVersion != null) {
            writer.writeLenAndDBEncodedPadString(this.tbProductVersion);
        } else {
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.mthrPid, 4);
        writer.writeInt(this.cps, 4);
        writer.writeInt(this.ncharset, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.charset = reader.readInt32();
        this.svrIsBigendian = reader.readInt32();
        this.svrIsNanobase = reader.readInt32();
        this.tbMajor = reader.readInt32();
        this.tbMinor = reader.readInt32();
        int tbProductNameLen = reader.readInt32();
        this.tbProductName = reader.readDBDecodedPadString(tbProductNameLen);
        int tbProductVersionLen = reader.readInt32();
        this.tbProductVersion = reader.readDBDecodedPadString(tbProductVersionLen);
        this.mthrPid = reader.readInt32();
        this.cps = reader.readInt32();
        this.ncharset = reader.readInt32();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgConnectReply msg = (TbMsgConnectReply)obj;
        if (this.charset != msg.charset) {
            return false;
        }
        if (this.svrIsBigendian != msg.svrIsBigendian) {
            return false;
        }
        if (this.svrIsNanobase != msg.svrIsNanobase) {
            return false;
        }
        if (this.tbMajor != msg.tbMajor) {
            return false;
        }
        if (this.tbMinor != msg.tbMinor) {
            return false;
        }
        if (this.tbProductName == null && msg.tbProductName != null || this.tbProductName != null && msg.tbProductName == null) {
            return false;
        }
        if (this.tbProductName != null && msg.tbProductName != null && !this.tbProductName.equals(msg.tbProductName)) {
            return false;
        }
        if (this.tbProductVersion == null && msg.tbProductVersion != null || this.tbProductVersion != null && msg.tbProductVersion == null) {
            return false;
        }
        if (this.tbProductVersion != null && msg.tbProductVersion != null && !this.tbProductVersion.equals(msg.tbProductVersion)) {
            return false;
        }
        if (this.mthrPid != msg.mthrPid) {
            return false;
        }
        if (this.cps != msg.cps) {
            return false;
        }
        return this.ncharset == msg.ncharset;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgConnectReply]/");
        str.append("charset=");
        str.append(this.charset);
        str.append("/");
        str.append("svrIsBigendian=");
        str.append(this.svrIsBigendian);
        str.append("/");
        str.append("svrIsNanobase=");
        str.append(this.svrIsNanobase);
        str.append("/");
        str.append("tbMajor=");
        str.append(this.tbMajor);
        str.append("/");
        str.append("tbMinor=");
        str.append(this.tbMinor);
        str.append("/");
        str.append("tbProductName=");
        str.append(this.tbProductName);
        str.append("/");
        str.append("tbProductVersion=");
        str.append(this.tbProductVersion);
        str.append("/");
        str.append("mthrPid=");
        str.append(this.mthrPid);
        str.append("/");
        str.append("cps=");
        str.append(this.cps);
        str.append("/");
        str.append("ncharset=");
        str.append(this.ncharset);
        str.append("/");
        return str.append("\n").toString();
    }
}

