/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public class TbMsgRollback
extends TbMsg {
    public String savepoint;

    public TbMsgRollback(int autoCommit) {
        this.msgType = 24;
        this.msgBodySize = 0;
        this.autoCommit = autoCommit;
    }

    public void set(String savepoint) {
        this.savepoint = savepoint;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.msgType, 4);
        writer.writeInt(this.msgBodySize, 4);
        writer.writeInt(this.autoCommit, 8);
        writer.writeLong(this.tsn, 8);
        if (this.savepoint != null) {
            writer.writeLenAndDBEncodedPadString(this.savepoint);
        } else {
            writer.writeInt(0, 4);
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 24, 4);
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        int savepointLen = reader.readInt32();
        this.savepoint = reader.readDBDecodedPadString(savepointLen);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TbMsgRollback msg = (TbMsgRollback)obj;
        if (this.savepoint == null && msg.savepoint != null || this.savepoint != null && msg.savepoint == null) {
            return false;
        }
        return this.savepoint == null || msg.savepoint == null || this.savepoint.equals(msg.savepoint);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[TbMsgRollback]/");
        str.append("savepoint=");
        str.append(this.savepoint);
        str.append("/");
        return str.append("\n").toString();
    }
}

