/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.common.TbMsgSerializable;
import java.sql.SQLException;

public class TbOutParam
implements TbMsgSerializable {
    public int dataType;
    public byte[] value;
    public int valueLen;
    public int colMetaArrayCnt;
    public TbColumnDesc[] colMeta;

    public void set(int dataType, byte[] value, int valueLen, int colMetaArrayCnt, TbColumnDesc[] colMeta) {
        this.dataType = dataType;
        this.value = value;
        this.valueLen = valueLen;
        this.colMetaArrayCnt = colMetaArrayCnt;
        this.colMeta = colMeta;
    }

    public void serialize(TbStreamDataWriter writer) throws SQLException {
        writer.writeInt(this.dataType, 4);
        if (this.valueLen != 0) {
            writer.writeInt(this.valueLen, 4);
            writer.writePadBytes(this.value, 0, this.valueLen);
        } else {
            writer.writeInt(0, 4);
            writer.writeInt(0, 4);
        }
        writer.writeInt(this.colMetaArrayCnt, 4);
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMetaArrayCnt; ++i) {
                this.colMeta[i].serialize(writer);
            }
        }
    }

    public void deserialize(TbStreamDataReader reader) throws SQLException {
        this.dataType = reader.readInt32();
        int valueLen = reader.readInt32();
        if (valueLen != 0) {
            this.value = new byte[valueLen];
            reader.readPadBytes(this.value, 0, valueLen);
        } else {
            reader.moveReadOffset(4);
            this.value = new byte[0];
        }
        int colMetaLen = reader.readInt32();
        if (colMetaLen > 0) {
            this.colMeta = new TbColumnDesc[colMetaLen];
            for (int i = 0; i < colMetaLen; ++i) {
                this.colMeta[i] = new TbColumnDesc();
                this.colMeta[i].deserialize(reader);
            }
        } else {
            this.colMeta = null;
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (obj == null) {
            return false;
        }
        TbOutParam msg = (TbOutParam)obj;
        if (this.dataType != msg.dataType) {
            return false;
        }
        if (this.value == null && msg.value != null || this.value != null && msg.value == null) {
            return false;
        }
        if (this.value != null && msg.value != null) {
            if (this.value.length != msg.value.length) {
                return false;
            }
            for (i = 0; i < msg.value.length; ++i) {
                if (this.value[i] == msg.value[i]) continue;
                return false;
            }
        }
        if (this.colMeta == null && msg.colMeta != null || this.colMeta != null && msg.colMeta == null) {
            return false;
        }
        if (this.colMeta != null && msg.colMeta != null) {
            if (this.colMeta.length != msg.colMeta.length) {
                return false;
            }
            for (i = 0; i < msg.colMeta.length; ++i) {
                if (this.colMeta[i].equals(msg.colMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer str = new StringBuffer("[TbOutParam]/");
        str.append("dataType=");
        str.append(this.dataType);
        str.append("/");
        str.append("value=");
        if (this.value != null) {
            for (i = 0; i < this.value.length; ++i) {
                str.append(this.value[i] + "/");
            }
        } else {
            str.append("null/");
        }
        str.append("colMeta={\n");
        if (this.colMeta != null) {
            for (i = 0; i < this.colMeta.length; ++i) {
                str.append("  colMeta[" + i + "]=" + this.colMeta[i]);
            }
        } else {
            str.append("=null");
        }
        str.append("}/");
        return str.append("\n").toString();
    }
}

