/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbCommon {
    private static String _NOT_NULL_EMPTY_STRING_ = "";

    public static int byte2int(byte[] bytes, int offset, int len) {
        int num = 0;
        for (int i = 0; i < len; ++i) {
            num |= (0xFF & bytes[offset + i]) << 8 * (len - 1 - i);
        }
        return num;
    }

    public static int byte2intR(byte[] bytes, int offset, int len) {
        int num = 0;
        for (int i = 0; i < len; ++i) {
            num |= (0xFF & bytes[offset + i]) << 8 * i;
        }
        return num;
    }

    public static long byte2long(byte[] bytes, int offset, int len) {
        long num = 0L;
        for (int i = 0; i < len; ++i) {
            num |= (long)((0xFF & bytes[offset + i]) << 8 * (len - 1 - i));
        }
        return num;
    }

    public static long byte2longR(byte[] bytes, int offset, int len) {
        long num = 0L;
        for (int i = 0; i < len; ++i) {
            num |= (long)((0xFF & bytes[offset + i]) << 8 * i);
        }
        return num;
    }

    public static boolean getBitmapAt(int position, int bitmap) {
        int base = 1;
        return (bitmap & (base <<= position)) != 0;
    }

    public static String getEmptyString(String str) {
        return str != null ? str : _NOT_NULL_EMPTY_STRING_;
    }

    public static String getEmptyString(String str, String defaultStr) {
        return str != null ? str : defaultStr;
    }

    public static int getPadLength(int byteLength) {
        int result = (4 - byteLength % 4) % 4;
        if (result == 0) {
            result = 4;
        }
        return result;
    }

    public static int int2bytes(int num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + len - 1 - i] = (byte)(0xFF & num >> 8 * i);
        }
        return len;
    }

    public static int int2bytesR(int num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = (byte)(0xFF & num >> 8 * i);
        }
        return len;
    }

    public static int long2bytes(long num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + len - 1 - i] = (byte)(0xFFL & num >> 8 * i);
        }
        return len;
    }

    public static int long2bytesR(long num, byte[] bytes, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            bytes[offset + i] = (byte)(0xFFL & num >> 8 * i);
        }
        return len;
    }

    public static void writePadding(byte[] buf, int startOffset, int padLen) {
        if (padLen != 0) {
            for (int i = 0; i < padLen; ++i) {
                buf[startOffset + i] = 0;
            }
        }
    }
}

