/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.util.TbStatementLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TbStatementLogger {
    private static boolean _logStatement = false;
    private static BufferedOutputStream _logOutStream = null;
    private static String _logFileExt = "rec";

    public static void setLogStatementFlag(boolean flag) {
        _logStatement = flag;
    }

    public static boolean getLogStatementFlag() {
        return _logStatement;
    }

    public static void logRecoveryStatement(TbPreparedStatement pstmt, DataTypeConverter typeConverter) {
        if (!_logStatement) {
            return;
        }
        if (_logOutStream == null) {
            try {
                String filename = TbStatementLogger._getLogFileName();
                _logOutStream = new BufferedOutputStream(new FileOutputStream(filename));
                filename = null;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            TbStatementLog.serializeData(_logOutStream, pstmt.getOriginalSql(), pstmt.getBindData(), typeConverter);
            _logOutStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getLogFilePrefixString() {
        return "tbjdbc-" + new SimpleDateFormat("yy-MM-dd-HHmmss").format(new Date());
    }

    private static String _getLogFileName() {
        String root = System.getProperty("user.home");
        String fileSep = System.getProperty("file.separator");
        String logFileName = TbStatementLogger.getLogFilePrefixString() + "." + _logFileExt;
        if (root == null) {
            return logFileName;
        }
        String clientDirecName = root + fileSep + "TiBero" + fileSep + "client";
        File clientDirec = new File(clientDirecName);
        if (!clientDirec.exists()) {
            return logFileName;
        }
        String logDirecName = clientDirecName + fileSep + "log";
        File logDirec = new File(logDirecName);
        if (!logDirec.exists() && !logDirec.mkdir()) {
            return logFileName;
        }
        clientDirec = null;
        logDirec = null;
        return logDirecName + fileSep + logFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws IOException, SQLException {
        if (args.length != 5) {
            System.out.println("invalid argument count.");
            return;
        }
        int stmtCnt = 0;
        boolean backupFlag = TbStatementLogger.getLogStatementFlag();
        DataTypeConverter typeConverter = new DataTypeConverter();
        Connection conn = null;
        FileInputStream fileIn = null;
        BufferedInputStream in = null;
        try {
            Class.forName(args[0]);
            conn = DriverManager.getConnection(args[1], args[2], args[3]);
            fileIn = new FileInputStream(args[4]);
            in = new BufferedInputStream(fileIn);
            TbStatementLog stmtLog = null;
            TbStatementLogger.setLogStatementFlag(false);
            while (true) {
                try {
                    stmtLog = TbStatementLog.deserializeData(in);
                    if (stmtLog == null) continue;
                    stmtLog.print(++stmtCnt);
                    stmtLog.execute(conn, typeConverter);
                    System.out.println("success!!");
                    System.out.println("");
                    continue;
                }
                catch (EOFException e) {
                    if (stmtLog != null) {
                        stmtLog.close();
                    }
                    stmtLog = null;
                }
                catch (SQLException e2) {
                    System.out.println("failed!! : " + e2.getMessage());
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (stmtLog != null) {
                        stmtLog.close();
                    }
                    stmtLog = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TbStatementLogger.setLogStatementFlag(backupFlag);
            fileIn.close();
            in.close();
            fileIn = null;
            in = null;
            typeConverter = null;
        }
    }
}

