/*
 * Decompiled with CFR 0.152.
 */
package Altibase.jdbc.driver;

import Altibase.jdbc.driver.ABCallableStatement;
import Altibase.jdbc.driver.ABDatabaseMetaData;
import Altibase.jdbc.driver.ABEncoder;
import Altibase.jdbc.driver.ABPooledConnection;
import Altibase.jdbc.driver.ABPreparedStatement;
import Altibase.jdbc.driver.ABResultSet;
import Altibase.jdbc.driver.ABSavepoint;
import Altibase.jdbc.driver.ABStatement;
import Altibase.jdbc.driver.ABTypes;
import Altibase.jdbc.driver.ABXAConsts;
import Altibase.jdbc.driver.ABXAResource;
import Altibase.jdbc.driver.SQLStates;
import Altibase.jdbc.driver.XID;
import Altibase.jdbc.driver.aTokenizer;
import Altibase.jdbc.driver.cm;
import Altibase.jdbc.driver.cmp;
import Altibase.jdbc.driver.ex;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ABConnection
implements cm,
SQLStates,
Connection,
ABXAConsts,
ABTypes {
    private cmp chn;
    private String mDBN = "JDBC";
    private ABPooledConnection pc;
    private Properties prop;
    private int txIsolation = 0;
    private boolean isXaOpened = false;
    private boolean isAutoCommit = true;
    private boolean mCalledMethodClose = false;
    private ex wn = new ex();
    private int mUID;
    private static int cUID = 0;

    ABConnection(Properties p) throws SQLException {
        String host = "localhost";
        String sUID = "SYS";
        String sPWD = "";
        int port = 20300;
        this.prop = p;
        port = this.getProperty("portNumber", port);
        ex.test(port < 1024, (short)84);
        this.mDBN = this.getProperty("databaseName", this.mDBN);
        sUID = this.getProperty("user", sUID);
        sPWD = this.getProperty("password", sPWD);
        host = this.getProperty("serverName", host);
        if (this.prop.getProperty("encoding") == null) {
            this.prop.setProperty("encoding", ABConnection.getSystemEncoding());
        }
        this.chn = cmp.connect(host, port);
        this.connect(sUID, sPWD);
        this.isAutoCommit = this.getProperty("AUTO_COMMIT", true);
        int v = this.getProperty("QUERY_TIMEOUT", -1);
        if (v >= 0 && v <= 3600) {
            this.chn.setProperty((byte)13, v);
        }
        v = this.getProperty("ISOLATION_LEVEL", 2);
        this.setTransactionIsolation(v);
        v = this.getProperty("IDLE_TIMEOUT", -1);
        if (v >= 0) {
            this.chn.setProperty((byte)12, v);
        }
        if ((v = this.getProperty("FETCH_TIMEOUT", -1)) >= 0) {
            this.chn.setProperty((byte)14, v);
        }
        if ((v = this.getProperty("UTRANS_TIMEOUT", -1)) >= 0) {
            this.chn.setProperty((byte)15, v);
        }
        host = this.getProperty("DATE_FORMAT", "YYYY-MM-DD HH24:MI:SS.FF6");
        this.chn.setProperty((byte)16, host);
    }

    public static String getSystemEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    void cancel(ABStatement stmt) throws SQLException {
        this.chn.cancel(stmt.getID());
    }

    final cmp chn() {
        return this.chn;
    }

    public void clearWarnings() throws SQLException {
        this.wn.clearWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        block11: {
            if (this.mUID == 0) {
                return;
            }
            this.mCalledMethodClose = true;
            this.wn.clearWarnings();
            if (this.pc == null) {
                this.chn.disconnect((byte)0);
                this.mUID = 0;
                break block11;
            }
            try {
                block12: {
                    try {
                        if (this.getAutoCommit()) break block12;
                        this.rollback();
                    }
                    catch (SQLException sQLException) {
                        Object var3_2 = null;
                        if (this.pc != null) {
                            this.pc.fireConnectionClosed();
                        }
                        break block11;
                    }
                }
                Object var3_1 = null;
                if (this.pc != null) {
                    this.pc.fireConnectionClosed();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.pc != null) {
                    this.pc.fireConnectionClosed();
                }
                throw throwable;
            }
        }
    }

    final void close(ABResultSet rs) throws SQLException {
        this.chn.close(rs);
    }

    public synchronized void commit() throws SQLException {
        ex.test(this.isXaOpened, (short)31);
        this.chn.transaction((byte)1);
    }

    final void connect() throws SQLException {
        this.connect(this.prop.getProperty("user"), this.prop.getProperty("password"));
    }

    final void connect(String uid, String pwd) throws SQLException {
        this.wn.clearWarnings();
        if (this.mUID == 0) {
            String nls = this.prop.getProperty("encoding");
            ex.test(this.chn == null, (short)26);
            this.chn.connect(this.mDBN, nls, uid, pwd, DriverManager.getLoginTimeout());
            this.mUID = ++cUID;
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        return new ABStatement(this);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 || resultSetConcurrency == 1008) {
            ex.exception((short)107);
        }
        return new ABStatement(this, resultSetType, resultSetConcurrency);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ex.test(resultSetHoldability != 1, (short)103, SQLStates.mFixmsg[0]);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    final int exec(ABPreparedStatement stmt) throws SQLException {
        return this.chn.exec(stmt);
    }

    final int writePrepareExecuteFetchReq(ABPreparedStatement stmt) throws SQLException {
        return this.chn.writePrepareExecuteFetchReq(stmt);
    }

    final int exec(ABStatement stmt) throws SQLException {
        return this.chn.exec(stmt);
    }

    final XID readXid() throws XAException {
        return this.chn.readXid();
    }

    final int writeDirectExecuteFetchReq(ABStatement aStatement) throws SQLException {
        return this.chn.writeDirectExecuteAndFetchReq(aStatement);
    }

    final int execArray(ABPreparedStatement stmt) throws SQLException {
        return this.chn.execArray(stmt);
    }

    synchronized int writeFetchRequest(ABResultSet rs) throws SQLException {
        return this.chn.writeFetchRequest(rs);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    final void free(ABStatement stmt) throws SQLException {
        this.chn.free(stmt);
    }

    public synchronized boolean getAutoCommit() {
        return this.isAutoCommit && !this.isXaOpened;
    }

    public String getCatalog() {
        return this.prop.getProperty("database", "mydb");
    }

    final ABEncoder getEncoder() {
        return this.chn.getEncoder();
    }

    String getExplainPlan(ABStatement stmt) throws SQLException {
        return this.chn.getExplainPlan(stmt.getID());
    }

    String getExplainPlan(ABResultSet rs) throws SQLException {
        return this.chn.getExplainPlan(rs.getStatementID());
    }

    public synchronized int getHoldability() throws SQLException {
        return 2;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return new ABDatabaseMetaData(this);
    }

    boolean getProperty(String key, boolean defValue) {
        String v = this.prop.getProperty(key);
        if (v != null) {
            defValue = v.startsWith("1") || v.toUpperCase().startsWith("T");
        }
        return defValue;
    }

    int getProperty(String key, int defValue) throws SQLException {
        String v = this.prop.getProperty(key);
        if (v != null) {
            try {
                defValue = Integer.parseInt(this.prop.getProperty(key));
            }
            catch (NumberFormatException e) {
                this.wn.warning((short)10, SQLStates.mWarmsg[3] + key + SQLStates.mWarmsg[4] + defValue);
            }
        }
        return defValue;
    }

    short getProperty(String key, short defValue) throws SQLException {
        String v = this.prop.getProperty(key);
        if (v != null) {
            try {
                defValue = Short.parseShort(v);
            }
            catch (NumberFormatException e) {
                this.wn.warning((short)10, SQLStates.mWarmsg[3] + key + SQLStates.mWarmsg[4] + defValue);
            }
        }
        return defValue;
    }

    String getProperty(String key, String defValue) {
        String v = this.prop.getProperty(key);
        if (v != null) {
            defValue = v;
        }
        return defValue;
    }

    int getQueryTimeout() throws SQLException {
        return this.chn.timeout();
    }

    int getTimeStamp() {
        return this.chn.getTimtStamp();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.txIsolation;
    }

    public Map getTypeMap() throws SQLException {
        return new Hashtable(0);
    }

    String getURL() {
        return aTokenizer.getUrl(this.prop);
    }

    public synchronized String getUser() throws SQLException {
        return this.prop.getProperty("user");
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.wn.getWarnings();
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.mCalledMethodClose;
    }

    public void resetCallClose() throws SQLException {
        this.mCalledMethodClose = false;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    final void meta(ABResultSet rs) throws SQLException {
        this.chn.meta(rs);
    }

    public String nativeSQL(String sql) throws SQLException {
        char c;
        int i;
        int sqlLength = sql.length();
        StringBuffer altiSql = new StringBuffer(sqlLength);
        StringBuffer tokenBuf = new StringBuffer(sqlLength);
        boolean in_string = false;
        for (i = 0; i < sqlLength && (c = sql.charAt(i)) == ' '; ++i) {
        }
        while (i < sqlLength) {
            c = sql.charAt(i);
            if (in_string) {
                altiSql.append(c);
                if (c == '\'') {
                    in_string = false;
                }
                ++i;
                continue;
            }
            if (c == '\'') {
                altiSql.append(c);
                in_string = true;
                ++i;
                continue;
            }
            if (c == '{') {
                tokenBuf.setLength(0);
                ++i;
                while (i < sqlLength && (c = sql.charAt(i)) == ' ') {
                    ++i;
                }
                for (int j = 0; j < 4; ++j) {
                    tokenBuf.append(c);
                    c = sql.charAt(++i);
                }
                if (tokenBuf.toString().equalsIgnoreCase("call")) {
                    altiSql.append("execute ");
                }
                ++i;
                continue;
            }
            if (c == '}') break;
            altiSql.append(c);
            ++i;
        }
        return altiSql.toString();
    }

    synchronized boolean prepare(ABPreparedStatement stmt) throws SQLException {
        return this.chn.writePrepareProtocol(stmt);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return new ABCallableStatement(this, sql);
    }

    public synchronized CallableStatement prepareCall(String unused, int resultSetType, int resultSetConcurrency) throws SQLException {
        ex.exception((short)107, SQLStates.mFixmsg[1]);
        return null;
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ex.exception((short)107, SQLStates.mFixmsg[2]);
        return null;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ABPreparedStatement(this, sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ex.exception((short)107);
        return null;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ex.exception((short)107);
        return null;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 || resultSetConcurrency == 1008) {
            ex.exception((short)107, SQLStates.mFixmsg[3]);
        }
        return new ABPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ex.test(resultSetHoldability != 1, (short)103, SQLStates.mFixmsg[0]);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ex.exception((short)107);
        return null;
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        ex.test(this.isAutoCommit, (short)31);
        ((ABSavepoint)savepoint).close();
    }

    public synchronized void rollback() throws SQLException {
        ex.test(this.isAutoCommit, (short)31);
        this.chn.transaction((byte)2);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        ((ABSavepoint)savepoint).rollback();
    }

    public synchronized void setAutoCommit(boolean b) throws SQLException {
        if (this.getAutoCommit() != b) {
            ex.test(this.isXaOpened, (short)31);
            this.chn.setProperty((byte)6, b ? (byte)1 : 0);
            this.isAutoCommit = b;
        }
    }

    public synchronized void setCatalog(String db) {
        this.mDBN = db;
        this.prop.setProperty("database", db);
    }

    synchronized void setConnect(String user, String password) throws SQLException {
        if (!this.getUser().equalsIgnoreCase(user)) {
            String nls = this.prop.getProperty("encoding");
            this.chn.disconnect((byte)1);
            this.chn.connect(this.mDBN, nls, user, password, this.chn.timeout());
        }
    }

    public void setExplainPlan(boolean attr) throws SQLException {
        this.chn.setProperty((byte)7, attr ? (byte)1 : 0);
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        ex.exception((short)107);
    }

    synchronized void setPooledConnection(ABPooledConnection aPC) {
        this.pc = aPC;
    }

    public synchronized void setQueryTimeout(int id, int unused) throws SQLException {
        this.chn.setProperty(id, (byte)13, unused);
    }

    public void setReadOnly(boolean b) throws SQLException {
        ex.test(b, (short)107, SQLStates.mFixmsg[4]);
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        ex.test(this.isXaOpened, (short)31);
        return new ABSavepoint(this, null);
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        ex.test(this.isXaOpened, (short)31);
        return new ABSavepoint(this, name);
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        boolean mode = this.getAutoCommit();
        if (this.txIsolation != level) {
            Statement st = this.createStatement();
            if (mode) {
                this.setAutoCommit(false);
            }
            switch (level) {
                case 8: {
                    st.execute("set transaction isolation level SERIALIZABLE ");
                    break;
                }
                case 2: {
                    st.execute("set transaction isolation level READ COMMITTED ");
                    break;
                }
                case 4: {
                    st.execute("set transaction isolation level REPEATABLE READ");
                    break;
                }
                case 1: {
                    ex.exception((short)103);
                }
                default: {
                    ex.exception((short)107);
                }
            }
            this.txIsolation = level;
            st.close();
            this.setAutoCommit(mode);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        ex.exception((short)107);
    }

    final int xa_exec_conn(Xid id, byte funcId, int rmid, long flags, long arg) throws SQLException {
        return this.chn.xa_exec_conn(id, funcId, rmid, flags, arg);
    }

    final int xa_trans(Xid id, byte funcId, int rmid, long flags, long arg) throws SQLException, XAException {
        return this.chn.xa_trans(id, funcId, rmid, flags, arg);
    }

    final boolean isXaOpened() {
        return this.isXaOpened;
    }

    synchronized XAResource xa_open() throws SQLException {
        int rmid = this.hashCode();
        ex.test(this.isXaOpened, (short)31, SQLStates.mFixmsg[5]);
        if (this.isAutoCommit) {
            this.chn.setProperty((byte)6, (byte)0);
        }
        boolean bl = this.isXaOpened = this.chn.xa_exec_conn(null, (byte)1, rmid, 0L, 0L) == 0;
        if (!this.isXaOpened) {
            if (this.isAutoCommit) {
                this.chn.setProperty((byte)6, (byte)1);
            }
        } else {
            return new ABXAResource(this);
        }
        ex.exception((short)23, SQLStates.mFixmsg[6]);
        return null;
    }

    synchronized void xa_close(int rmid) throws SQLException {
        if (this.isXaOpened) {
            this.isXaOpened = false;
            this.chn.xa_exec_conn(null, (byte)2, rmid, 0x400000L, 0L);
            if (this.isAutoCommit) {
                this.chn.setProperty((byte)6, (byte)1);
            }
        }
    }

    public int getUID() {
        return this.mUID;
    }

    public String getEncoding() {
        return this.prop.getProperty("encoding");
    }
}

