/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.type.RecordType;
import egovframework.rte.itl.integration.type.Type;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.data.WebServiceServerDefinition;
import egovframework.rte.itl.webservice.service.ServiceEndpointInfo;
import egovframework.rte.itl.webservice.service.ServiceParamInfo;
import egovframework.rte.itl.webservice.service.impl.ServiceParamInfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.jws.WebParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceEndpointInfoImpl
implements ServiceEndpointInfo {
    private Log LOG = LogFactory.getLog(this.getClass());
    private String namespace;
    private String address;
    private String serviceName;
    private String portName;
    private String operationName;
    private ServiceParamInfo returnInfo;
    private Collection<ServiceParamInfo> paramInfos;

    public ServiceEndpointInfoImpl(String namespace, String address, String serviceName, String portName, String operationName, ServiceParamInfo returnInfo, Collection<ServiceParamInfo> paramInfos) {
        if (!StringUtils.hasText((String)namespace)) {
            this.LOG.error((Object)("Argument 'namespace' has no text (" + namespace + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)address)) {
            this.LOG.error((Object)("Argument 'address' has no text (" + address + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)serviceName)) {
            this.LOG.error((Object)("Argument 'serviceName' has no text (" + serviceName + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)portName)) {
            this.LOG.error((Object)("Argument 'portName' has no text (" + portName + ")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)operationName)) {
            this.LOG.error((Object)("Argument 'operationName' has no text (" + operationName + ")"));
            throw new IllegalArgumentException();
        }
        if (paramInfos == null) {
            this.LOG.error((Object)"Argument 'paramInfos' is null");
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
        this.address = address;
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.returnInfo = returnInfo;
        this.paramInfos = paramInfos;
    }

    public ServiceEndpointInfoImpl(WebServiceServerDefinition webServiceServerDefinition, RecordType requestType, RecordType responseType) {
        if (webServiceServerDefinition == null) {
            this.LOG.error((Object)"Argument 'webServiceServerDefinition' is null");
            throw new IllegalArgumentException();
        }
        if (!webServiceServerDefinition.isValid()) {
            this.LOG.error((Object)"Argument 'webServiceServerDefinition' is invalid");
            throw new IllegalArgumentException();
        }
        if (requestType == null) {
            this.LOG.error((Object)"Argument 'requestType' is null");
            throw new IllegalArgumentException();
        }
        if (responseType == null) {
            this.LOG.error((Object)"Argument 'responseType' is null");
            throw new IllegalArgumentException();
        }
        this.namespace = webServiceServerDefinition.getNamespace();
        this.address = webServiceServerDefinition.getAddress();
        this.serviceName = webServiceServerDefinition.getServiceName();
        this.portName = webServiceServerDefinition.getPortName();
        this.operationName = webServiceServerDefinition.getOperationName();
        this.returnInfo = null;
        this.paramInfos = new ArrayList<ServiceParamInfo>();
        this.paramInfos.add(new ServiceParamInfoImpl("header", EgovWebServiceMessageHeader.TYPE, WebParam.Mode.INOUT, true));
        for (Map.Entry entry : requestType.getFieldTypes().entrySet()) {
            this.paramInfos.add(new ServiceParamInfoImpl((String)entry.getKey(), (Type)entry.getValue(), WebParam.Mode.IN, false));
        }
        for (Map.Entry entry : responseType.getFieldTypes().entrySet()) {
            this.paramInfos.add(new ServiceParamInfoImpl((String)entry.getKey(), (Type)entry.getValue(), WebParam.Mode.OUT, false));
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public ServiceParamInfo getReturnInfo() {
        return this.returnInfo;
    }

    @Override
    public Collection<ServiceParamInfo> getParamInfos() {
        return this.paramInfos;
    }

    @Override
    public String getWsdlAddress() {
        return null;
    }
}

