/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.RandomGuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.UuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.server.AddressingEndpointInterceptor;
import org.springframework.ws.soap.addressing.version.Addressing10;
import org.springframework.ws.soap.addressing.version.Addressing200408;
import org.springframework.ws.soap.addressing.version.AddressingVersion;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.xml.transform.TransformerObjectSupport;

public abstract class AbstractAddressingEndpointMapping
extends TransformerObjectSupport
implements SoapEndpointMapping,
InitializingBean {
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;
    private MessageIdStrategy messageIdStrategy;
    private WebServiceMessageSender[] messageSenders = new WebServiceMessageSender[0];
    private AddressingVersion[] versions;
    private EndpointInterceptor[] preInterceptors = new EndpointInterceptor[0];
    private EndpointInterceptor[] postInterceptors = new EndpointInterceptor[0];

    protected AbstractAddressingEndpointMapping() {
        this.initDefaultStrategies();
    }

    protected void initDefaultStrategies() {
        this.versions = new AddressingVersion[]{new Addressing200408(), new Addressing10()};
        this.messageIdStrategy = JdkVersion.isAtLeastJava15() ? new UuidMessageIdStrategy() : new RandomGuidMessageIdStrategy();
    }

    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull((Object)actorOrRole, (String)"actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty((Object[])actorsOrRoles, (String)"actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }

    public final void setPreInterceptors(EndpointInterceptor[] preInterceptors) {
        Assert.notNull((Object)preInterceptors, (String)"'preInterceptors' must not be null");
        this.preInterceptors = preInterceptors;
    }

    public final void setPostInterceptors(EndpointInterceptor[] postInterceptors) {
        Assert.notNull((Object)postInterceptors, (String)"'postInterceptors' must not be null");
        this.postInterceptors = postInterceptors;
    }

    public final void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        Assert.notNull((Object)messageIdStrategy, (String)"'messageIdStrategy' must not be null");
        this.messageIdStrategy = messageIdStrategy;
    }

    public final void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        Assert.notNull((Object)messageSenders, (String)"'messageSenders' must not be null");
        this.messageSenders = messageSenders;
    }

    public final void setVersions(AddressingVersion[] versions) {
        this.versions = versions;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Supporting " + Arrays.asList(this.versions)));
        }
    }

    public final EndpointInvocationChain getEndpoint(MessageContext messageContext) throws TransformerException {
        Assert.isInstanceOf((Class)SoapMessage.class, (Object)messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        for (int i = 0; i < this.versions.length; ++i) {
            MessageAddressingProperties requestMap;
            if (!this.supports(this.versions[i], request)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Request [" + request + "] uses [" + this.versions[i] + "]"));
            }
            if ((requestMap = this.versions[i].getMessageAddressingProperties(request)) == null) {
                return null;
            }
            Object endpoint = this.getEndpointInternal(requestMap);
            if (endpoint == null) {
                return null;
            }
            return this.getEndpointInvocationChain(endpoint, this.versions[i], requestMap);
        }
        return null;
    }

    private EndpointInvocationChain getEndpointInvocationChain(Object endpoint, AddressingVersion version, MessageAddressingProperties requestMap) {
        URI responseAction = this.getResponseAction(endpoint, requestMap);
        URI faultAction = this.getFaultAction(endpoint, requestMap);
        EndpointInterceptor[] interceptors = new EndpointInterceptor[this.preInterceptors.length + this.postInterceptors.length + 1];
        System.arraycopy(this.preInterceptors, 0, interceptors, 0, this.preInterceptors.length);
        AddressingEndpointInterceptor interceptor = new AddressingEndpointInterceptor(version, this.messageIdStrategy, this.messageSenders, responseAction, faultAction);
        interceptors[this.preInterceptors.length] = interceptor;
        System.arraycopy(this.postInterceptors, 0, interceptors, this.preInterceptors.length + 1, this.postInterceptors.length);
        return new SoapEndpointInvocationChain(endpoint, interceptors, this.actorsOrRoles, this.isUltimateReceiver);
    }

    private boolean supports(AddressingVersion version, SoapMessage request) {
        SoapHeader header = request.getSoapHeader();
        if (header != null) {
            Iterator iterator = header.examineAllHeaderElements();
            while (iterator.hasNext()) {
                SoapHeaderElement headerElement = (SoapHeaderElement)iterator.next();
                if (!version.understands(headerElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract Object getEndpointInternal(MessageAddressingProperties var1);

    protected abstract URI getResponseAction(Object var1, MessageAddressingProperties var2);

    protected abstract URI getFaultAction(Object var1, MessageAddressingProperties var2);
}

