/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.metadata;

import egovframework.rte.itl.integration.metadata.RecordTypeFieldDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordTypeDefinition
implements Validatable {
    private String id;
    private RecordTypeDefinition parent;
    private String name;
    private Map<String, RecordTypeFieldDefinition> fields = new HashMap<String, RecordTypeFieldDefinition>();
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public RecordTypeDefinition() {
    }

    public RecordTypeDefinition(String id, String name) {
        this.id = id;
        this.name = name;
        this.statusChanged.set(true);
    }

    public RecordTypeDefinition(String id, String name, RecordTypeDefinition parent) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.statusChanged.set(true);
    }

    public RecordTypeDefinition(String id, String name, RecordTypeDefinition parent, Map<String, RecordTypeFieldDefinition> fields) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.fields = fields;
        this.statusChanged.set(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.statusChanged.set(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.statusChanged.set(true);
    }

    public RecordTypeDefinition getParent() {
        return this.parent;
    }

    public void setParent(RecordTypeDefinition parent) {
        this.parent = parent;
        this.statusChanged.set(true);
    }

    public Map<String, RecordTypeFieldDefinition> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, RecordTypeFieldDefinition> fields) {
        this.fields = fields;
        this.statusChanged.set(true);
    }

    public RecordTypeFieldDefinition getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public RecordTypeFieldDefinition putField(String fieldName, RecordTypeFieldDefinition field) {
        this.statusChanged.set(true);
        return this.fields.put(fieldName, field);
    }

    public RecordTypeFieldDefinition removeField(String fieldName) {
        this.statusChanged.set(true);
        return this.fields.remove(fieldName);
    }

    @Override
    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && this.fields != null;
            if (this.fields != null) {
                for (RecordTypeFieldDefinition field : this.fields.values()) {
                    boolean bl2 = this.valid = this.valid && field.isValid();
                }
            }
            if (this.parent != null) {
                this.valid = this.valid && this.parent.isValid();
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tid = ").append(StringUtils.quote((String)this.id)).append("\n\tname = ").append(StringUtils.quote((String)this.name)).append("\n\tparent = ").append(this.parent == null ? "" : "\n").append(this.parent);
        if (this.fields == null) {
            sb.append("\n\tfields = null");
        } else {
            sb.append("\n\tfields = {");
            for (Map.Entry<String, RecordTypeFieldDefinition> entry : this.fields.entrySet()) {
                sb.append("\n\t\t<key = ").append(StringUtils.quote((String)entry.getKey())).append(", value = ").append(entry.getValue() == null ? "" : "\n").append(entry.getValue()).append(">");
            }
            sb.append("\n\t}");
        }
        sb.append("\n}");
        return sb.toString();
    }
}

